<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">

<head>
    <meta charset="utf-8">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <!-- Basic -->
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    {{--  --}}
    <meta itemprop="image" content="/assets/images/uniq-produce.jpg" />
    <meta property="og:image" itemprop="image/*" content="/assets/images/uniq-produce.jpg" />
    <meta property="og:image:width" content="256" />
    <meta property="og:image:height" content="256" />
    <meta property="og:site_name" content="uniqproduce.ma" />
    {{--  --}}
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <!-- Mobile Metas -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="shortcut icon" type="image/x-icon" href="/assets/images/favicon-produce.png">

    @yield('metatags')

    {{--  --}}
    <title>@yield('title') - Unique Produce</title>

    {{--  --}}
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.14.0/css/all.min.css" />
    {{-- <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.5.8/slick.min.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.5.8/slick-theme.min.css" /> --}}
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.theme.default.min.css">
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet" />
    
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.0/dist/css/bootstrap.min.css" />

    <link href="{{ asset('assets/css/style.css') }}" rel="stylesheet">
    @yield('styles')

</head>

<body>

    @include('frontend/partials/header')
    @yield('content')
    @include('frontend/partials/footer')


    <div class="float-sm">
        <div class="fl-fl float-fb">
          <i class="fab fa-facebook-f"></i>
          <a href="https://www.facebook.com/SmartCityArtGallery/" target="_blank"> Like us!</a>
        </div>
        <div class="fl-fl float-ig">
          <i class="fab fa-instagram"></i>
          <a href="https://www.instagram.com/SmartCityArtGallery/" target="_blank">Follow us!</a>
        </div>
        <div class="fl-fl float-in">
            <i class="fab fa-linkedin"></i>
            <a href="https://www.linkedin.com/SmartCityArtGallery/" target="_blank">Follow us!</a>
          </div>
          
      </div>
    
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.1/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"></script>
    {{-- <script src="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.5.8/slick.min.js"></script> --}}
    @yield('scripts')
    <script src="{{ asset('assets/js/main.js') }}"></script>

    <script>
        //AOS.init();
        AOS.init({disable: 'mobile'});

        document.querySelectorAll('a[href^="#"]').forEach((anchor) => {
      anchor.addEventListener("click", function (e) {
        e.preventDefault();

        document.querySelector(this.getAttribute("href")).scrollIntoView({
          behavior: "smooth",
        });
      });
    });



$(window).on("load", function() {
  $(".owl-carousel-prod").owlCarousel({
    loop:true,
    nav:true,
    items:2,
    margin:10,
    autoplay:false,
    dots: false,
    navText:["<i class='fa fa-chevron-left  custom--arrow '></i>","<i class='fa fa-chevron-right  custom--arrow '></i>" ],

    responsiveClass:true,
    responsive:{
        0:{
            items:1,
            nav:true
        },
        600:{
            items:1,
            nav:false
        },
        1000:{
            items:2,
            nav:true,
            loop:false
        }
    }
  });
});

$(".owl-carousel-single").owlCarousel({
      items: 4,
      nav: true,
      dots: false,
      loop: true,
      margin: 10,
      mouseDrag: true,
      responsiveClass: true,
      autoplay: true,
      autoplayTimeout: 3000,
      autoplayHoverPause: true,
      navText:["<i class='fa fa-chevron-left  custom--arrow '></i>","<i class='fa fa-chevron-right  custom--arrow '></i>" ],
      responsive: {
        0: {
          items: 1,
        },
        480: {
          items: 2,
        },
        767: {
          items: 3,
        },
        992: {
          items: 3,
        },
        1200: {
          items: 4,
        },
      },
    });

    </script>

</body>

</html>
