@extends('backend.layouts.app')

@section('title', 'Edit Attribut')

@push('styles')
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-fileinput/4.4.5/css/fileinput.min.css" media="all" rel="stylesheet" type="text/css" />
@endpush


@section('content')



   <div class="block-header">
        <ol class="breadcrumb breadcrumb-col-pink">
                                <li><a href="/admin"><i class="material-icons">home</i> Home</a></li>
                                <li><a href="{{route('admin.attrib.show',$attrib->id)}}"><i class="material-icons">library_books</i> Rows </a></li>
                                <li class="active"><i class="material-icons">edit</i>Edit Row</li>
                            </ol>
    </div>



             <form method="POST" action="{{route('admin.attrib.update',$attrib->id)}}" enctype="multipart/form-data" id="form_validation"  novalidate="novalidate">
                 @csrf
                 @method('PUT')

                  
    <div class="row clearfix">
   <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
   <div class="card">
    <div class="body">
           <!--row clearfix -->
                   <div class="row clearfix">
                       
                    <div class="col-md-12">
                    <label class="col-form-label"> <strong style="color:black"> Title  </strong> :</label>      
                          <div class="input-group">
                              <div class="form-line">
                                  <input type="text" name="title" class="form-control text" placeholder="Title ..." value="{{$attrib->title}}">
                              </div>
                          </div>
                      </div>


                 </div>
<!--end row clearfix -->

      <div class="col-md-12">
        <div class="card" id="div_gallery">
            <div class="header">
                <h2>Galerie images :</h2>
            </div>
                <div class="body">
                  <div class="row clearfix" >
                    <div class="gallery-box" id="gallerybox">
                            <?php   $images=explode('|',$attrib->images); ?>           

                        @for($i=0 ; $i<@count($images)-1 ; $i++)
                        <div class="gallery-image-edit" id="gallery-{{$i}}">

                            <button type="button" data-id="{{$i}}" data-id_g="{{$attrib->id}}" class="btn-danger btn-sm .btn-circle" ><i class="material-icons">delete_forever</i></button>

                            <img class="img-responsive" src="{{asset('storage/attribs/'.$images[$i])}}" alt="{{$images[$i]}}">
                          </div>
                        @endfor
                    </div>
                    <div class="gallery-box">
                        <hr>
                        <input type="file" name="images[]" value="UPLOAD" id="gallaryimageupload" multiple accept="image/*">
                        <button type="button" class="btn btn-info btn-lg right" id="galleryuploadbutton">UPLOAD GALLERY IMAGE</button>
                    </div>
                  </div>
                </div>
            </div>
       </div>     

<!-- row clearfix -->
            <div class="row clearfix">
                <div class="col-md-12">
                     <!-- -------------Description-------- -->                 
                    <div class="form-group">
                        <label for="tinymce">Description :</label>
                        <textarea name="description" id="tinymce" >{{$attrib->description}}</textarea>
                    </div>
                </div>
                

            </div>


                     <button type="submit" class="btn btn-primary btn-block m-t-15 waves-effect"><i class="material-icons">edit </i> Modifier</button>





                
           </div><!-- end body -->
        </div><!-- end card -->
</div>


     

        
    </div>
</form>



@endsection




@push('scripts')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-fileinput/4.4.5/js/fileinput.min.js"></script>
    <script src="{{asset('backend/plugins/tinymce/tinymce.js')}}"></script>
            <!-- validation -->
      <script src="{{ asset('backend/plugins/jquery-validation/jquery.validate.js')}}"></script>
        <!-- Custom Js -->
       <script src="{{ asset('backend/js/pages/forms/form-validation.js')}}"></script>



      <script>
        $(function () {
            tinymce.init({
                selector: "textarea#tinymce",
                theme: "modern",
                height: 300,
                plugins: [
                    'advlist autolink lists link image charmap print preview hr anchor pagebreak',
                    'searchreplace wordcount visualblocks visualchars code fullscreen',
                    'insertdatetime media nonbreaking save table contextmenu directionality',
                    'emoticons template paste textcolor colorpicker textpattern imagetools'
                ],
                toolbar1: 'insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image',
                toolbar2: 'print preview media | forecolor backcolor emoticons',
                image_advtab: true
            });
            tinymce.suffix = ".min";
            tinyMCE.baseURL = '{{asset('backend/plugins/tinymce')}}';
        });


//remove image with ajax
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        

        // DELETE produit GALLERY IMAGE
        $('.gallery-image-edit button').on('click',function(e){
            e.preventDefault();
            var id = $(this).data('id');
            var id_g = $(this).data('id_g');
            var image = $('#gallery-'+id+' img').attr('alt');
            console.log(image);
            $.post("{{route('admin.deletePhotoAttrib')}}",{position:id,id_g:id_g,image:image},function(data){
                if(data.msg == true){
                  $('#gallery-'+id).remove();
                }
            });
        });

        $(function() {
            // Multiple images preview in browser
            var imagesPreview = function(input, placeToInsertImagePreview) {

                if (input.files) {
                    var filesAmount = input.files.length;

                    for (i = 0; i < filesAmount; i++) {
                        var reader = new FileReader();

                        reader.onload = function(event) {

                            $('<div class="gallery-image-edit" id="gallery-perview-'+i+'"><img src="'+event.target.result+'" class="img-responsive"/></div>').appendTo(placeToInsertImagePreview);
                        }

                        reader.readAsDataURL(input.files[i]);
                    }
                }

            };

            $('#gallaryimageupload').on('change', function() {
                imagesPreview(this, 'div#gallerybox');
            });
        });

        $(document).on('click','#galleryuploadbutton',function(e){
            e.preventDefault();
            $('#gallaryimageupload').click();
        })



    </script>


@endpush

