@extends('backend.layouts.app')

@section('title', 'Posts')

@push('styles')

    <!-- JQuery DataTable Css -->
    <link rel="stylesheet" href="{{ asset('backend/plugins/jquery-datatable/skin/bootstrap/css/dataTables.bootstrap.css') }}">

@endpush

@section('content')


    <div class="block-header">
        <ol class="breadcrumb breadcrumb-col-pink">
                                <li><a href="/admin"><i class="material-icons">home</i> Home</a></li>
                                <li class="active"><i class="material-icons">description</i>Posts</li>
                            </ol>
    </div>

    <div class="row clearfix">
        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
            <div class="card">
                <div class="header">
                    <h2>POST LIST</h2>
               <ul class="header-dropdown m-r--5">
                     <li class="dropdown">
     <a href="{{route('admin.post.create')}}" class="btn bg-indigo btn-circle waves-effect waves-circle waves-float waves-light">
        <i class="material-icons left" style="color:#fff">add</i></a>
                      </li>
                      </ul>

                </div>
                <div class="body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped table-hover dataTable js-exportable">
                            <thead>
                                <tr>
                                    <th>SL.</th>
                                    <th>Image</th>
                                    <th>Title</th>
                                    <th>Author</th>
                                    <th>Category</th>
                                    <th><i class="material-icons">visibility</i></th>
                                    <th>Is Approved</th>
                                    <th>Status</th>
                                    <th><i class="material-icons small">comment</i></th>
                                    <th class="text-center" width="150">Action</th>
                                </tr>
                            </thead>

                            <tbody>
                                @foreach( $posts as $key => $post )
                                <tr>
                                    <td>{{$key+1}}</td>
                                    <td>
                                        @if(Storage::disk('public')->exists('posts/'.$post->image))
                                            <img src="{{asset('storage/posts/'.$post->image)}}" alt="{{$post->title}}" class="img-responsive img-rounded" width="100px" height="100px">
                                        @endif
                                    </td>
                                    <td>
                                        <span title="{{$post->title}}">
                        {{ \Illuminate\Support\Str::limit($post->title ?? '',10,' ...') }}
                                        </span>
                                    </td>
                                    <td>{{$post->admin->name}}</td>
                                    <td>
                                        @foreach($post->categories as $key=>$category)
                                <a href="{{route('admin.categoriePost.edit',$category->id)}}" target="_blanck">
                                       <span class="label bg-blue-grey"> {{$category->name}}</span>
                                    </a>
                                        @endforeach
                                    </td>
                                    <td>{{$post->view_count}}</td>
                                    <td>
                                 <a href="{{route('admin.post.approve',$post->id)}}"  class="badge {{$post->is_approved == true ? 'bg-green' : 'bg-pink '}}">{{$post->is_approved == true ? 'Approved' : 'Pending '}}</a>
                                    </td>
                                    <td>

                                    <a href="{{url('admin/post/enable/'.$post->id)}}" class="badge {{$post->status == true ? 'bg-green' : 'bg-pink '}}">{{$post->status == true ? 'Published' : 'Pending'}}</a>
                                    </td>
                                    <td>
                                        <span class="badge">
                                            <i class="material-icons small left">comment</i>
                                            {{ $post->comments_count }}
                                        </span>
                                    </td>
                                    <td class="text-center">
                                       {{-- <a href="{{route('admin.post.show',$post->id)}}" class="btn btn-success btn-sm waves-effect">
                                            <i class="material-icons">visibility</i>
                                        </a>
                                        --}}
                                        <a href="{{route('admin.post.edit',$post->id)}}" class="btn btn-info btn-sm waves-effect">
                                            <i class="material-icons">edit</i>
                                        </a>
                                        <button type="button" class="btn btn-danger btn-sm waves-effect" onclick="deletePost({{$post->id}})">
                                            <i class="material-icons">delete</i>
                                        </button>
                                        <form action="{{route('admin.post.destroy',$post->id)}}" method="POST" id="del-post-{{$post->id}}" style="display:none;">
                                            @csrf
                                            @method('DELETE')
                                        </form>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection


@push('scripts')

    <!-- Jquery DataTable Plugin Js -->
    <script src="{{ asset('backend/plugins/jquery-datatable/jquery.dataTables.js') }}"></script>
    <script src="{{ asset('backend/plugins/jquery-datatable/skin/bootstrap/js/dataTables.bootstrap.js') }}"></script>
    <script src="{{ asset('backend/plugins/jquery-datatable/extensions/export/dataTables.buttons.min.js') }}"></script>
    <script src="{{ asset('backend/plugins/jquery-datatable/extensions/export/buttons.flash.min.js') }}"></script>
    <script src="{{ asset('backend/plugins/jquery-datatable/extensions/export/jszip.min.js') }}"></script>
    <script src="{{ asset('backend/plugins/jquery-datatable/extensions/export/pdfmake.min.js') }}"></script>
    <script src="{{ asset('backend/plugins/jquery-datatable/extensions/export/vfs_fonts.js') }}"></script>
    <script src="{{ asset('backend/plugins/jquery-datatable/extensions/export/buttons.html5.min.js') }}"></script>
    <script src="{{ asset('backend/plugins/jquery-datatable/extensions/export/buttons.print.min.js') }}"></script>

    <!-- Custom Js -->
    <script src="{{ asset('backend/js/pages/tables/jquery-datatable.js') }}"></script>

    <script>
        function deletePost(id){
            
            swal({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.value) {
                    document.getElementById('del-post-'+id).submit();
                    swal(
                    'Deleted!',
                    'Post has been deleted.',
                    'success'
                    )
                }
            })
        }
    </script>


@endpush