@extends('backend.layouts.app')

@section('title', 'Sliders')

@push('styles')

    <!-- JQuery DataTable Css -->
    <link rel="stylesheet" href="{{ asset('backend/plugins/jquery-datatable/skin/bootstrap/css/dataTables.bootstrap.css') }}">

@endpush


@section('content')


    <div class="block-header">
        <ol class="breadcrumb breadcrumb-col-pink">
                                <li><a href="/admin"><i class="material-icons">home</i> Home</a></li>
                                <li class="active"><i class="material-icons">label</i>Slider</li>
                            </ol>
    </div>


    <div class="row clearfix">
        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
            <div class="card">
                <div class="header">
                    <h2>
                        Slider List
                    </h2>
               <ul class="header-dropdown m-r--5">
                     <li class="dropdown">
     <a href="{{route('admin.banner.create')}}" class="btn bg-indigo btn-circle waves-effect waves-circle waves-float waves-light">
        <i class="material-icons left" style="color:#fff">add</i></a>
                      </li>
                      </ul>

                </div>
                <div class="body">
                 <div class="table-responsive">
                        <table class="table table-bordered table-striped table-hover dataTable js-exportable">
                          
                        <thead>
                            <tr style="background-color:#E9FAF0; " >
                                <th class="text-center">#</th>
                                <th class="text-center">Image</th>

                                <th class="text-center">Title</th>
                                <th class="text-center">SubTitle</th>
                                <th class="text-center">Date created</th>
                                <th class="text-center">Date updated</th>
                                <th class="text-center">ACTION</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($banners as $banner )
                                <tr>
                                
                                    <th scope="row">{{ $banner->id }}</th>
                                    <td><img src="{{asset('storage/banners/'.$banner->photo)}}" style="width:80px"></td>
                                    <td>{{ $banner->title }}</td>
                                    <td>{{ $banner->subtitle }}</td>

                                    <td>{{ $banner->created_at->toFormattedDateString() }}</td>
                                    <td>{{ $banner->updated_at->toFormattedDateString() }}</td>
                
                                      <td class="text-center">
                                        <a href="{{route('admin.banner.edit',$banner->id)}}" class="btn btn-info btn-sm waves-effect">
                                            <i class="material-icons">edit</i>
                                        </a>
                                        <button type="button" class="btn btn-danger btn-sm waves-effect" onclick="deleteSlider({{$banner->id}})">
                                            <i class="material-icons">delete</i>
                                        </button>

                                        <form action="{{route('admin.banner.destroy',$banner->id)}}" method="POST" id="del-banner-{{$banner->id}}" style="display:none;">
                                            @csrf
                                            @method('DELETE')
                                        </form>

                                    </td>


                              </tr>



                            @endforeach
                            
                        </tbody>
                    </table>
                </div>
            </div>
            </div>
        </div>
    </div>

    <div class="row clearfix">
        @foreach($banners as $banner )
      
        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
            <div class="card">
                <div class="header">
                    <h2>{{ $banner->id }}

                    <ul class="header-dropdown m-r--5">
                        <li class="dropdown">
                            <a href="javascript:void(0);" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">
                                <i class="material-icons">more_vert</i>
                            </a>
                            <ul class="dropdown-menu pull-right">
                                <li><a href="javascript:void(0);">Action</a></li>
                                <li><a href="javascript:void(0);">Another action</a></li>
                                <li><a href="javascript:void(0);">Something else here</a></li>
                            </ul>
                        </li>
                    </ul>
                </div>
                <div class="body">
                    <div id="carousel-example-generic_2" class="carousel slide" data-ride="carousel">
                        <div class="carousel-inner" role="listbox">
                            <div class="item active">
                                <img src="{{asset('storage/banners/'.$banner->photo)}}" width="100%" style="height:400px" />
                                <div class="carousel-caption">
                                    <h3>{{ $banner->title }}</h3>
                                    <p>{{ $banner->subtitle }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
         @endforeach
    </div>


@endsection



@push('scripts')

    <!-- Jquery DataTable Plugin Js -->
    <script src="{{ asset('backend/plugins/jquery-datatable/jquery.dataTables.js') }}"></script>
    <script src="{{ asset('backend/plugins/jquery-datatable/skin/bootstrap/js/dataTables.bootstrap.js') }}"></script>
    <script src="{{ asset('backend/plugins/jquery-datatable/extensions/export/dataTables.buttons.min.js') }}"></script>
    <script src="{{ asset('backend/plugins/jquery-datatable/extensions/export/buttons.flash.min.js') }}"></script>
    <script src="{{ asset('backend/plugins/jquery-datatable/extensions/export/jszip.min.js') }}"></script>
    <script src="{{ asset('backend/plugins/jquery-datatable/extensions/export/pdfmake.min.js') }}"></script>
    <script src="{{ asset('backend/plugins/jquery-datatable/extensions/export/vfs_fonts.js') }}"></script>
    <script src="{{ asset('backend/plugins/jquery-datatable/extensions/export/buttons.html5.min.js') }}"></script>
    <script src="{{ asset('backend/plugins/jquery-datatable/extensions/export/buttons.print.min.js') }}"></script>

    <!-- Custom Js -->
    <script src="{{ asset('backend/js/pages/tables/jquery-datatable.js') }}"></script>

    <script>
        function deleteSlider(id){
            
            swal({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.value) {
                    document.getElementById('del-banner-'+id).submit();
                    swal(
                    'Deleted!',
                    'banner has been deleted.',
                    'success'
                    )
                }
            })
        }
    </script>


@endpush