<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Schema;
use Carbon\Carbon;
use App\Message;
use App\Language;
use App\CategoriePost;
use App\Tag;
use App\Post;
use App\Product;
use App\Galerie;
use App\Video;
use App\Setting;
use App\Partner;

class AppServiceProvider extends ServiceProvider
{

    public function register()
    {
        //
    }

 
    public function boot()
    {
Schema::defaultStringLength(191);

        if (! $this->app->runningInConsole()) {

            view()->composer('frontend.*', function($view) {
                $view->with('languages', Language::select('code','logo')->get());
            });

            view()->composer('backend.partials.navbar', function($view) {
                $view->with('countmessages', Message::whereStatus(0)->count());
                $view->with('navbarmessages', Message::whereStatus(0)->take(5)->get());
            });


            view()->composer('frontend.*', function($view) {
                $view->with('categoriesPost',CategoriePost::latest()->get());
                $view->with('tags',Tag::latest()->get());
                // $view->with('presentation',Presentation::first());
                $view->with('settings',Setting::first());
                $view->with('galeriee',Galerie::whereStatus(1)->get());
                $view->with('videos',Video::whereStatus(1)->get());
                $view->with('postss',Post::whereStatus(1)->latest()->get());
                $view->with('partners',Partner::all());
                $view->with('productss',Product::whereStatus(1)->get());



             });













     
                                       }

 }


}
