<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Product;
use App\Attrib;

class ProductController extends Controller
{
 

 public function index(Request $request)
 {
       $products=Product::whereStatus(1)->get();
       $markers = [];  
       $infoWindowContent= []; 


       foreach ($products as $key => $product) {

        $markers[]=[$product->title];
        
        $url = url("/storage/products/".$product->image);
        $route = route("singleProduct",[$product->id,$product->slug]);
        $infoWindowContent[]=["<div class='detail_point'><a href='{$route}'><img src='{$url}' alt='".getTranslationProduct($product->id)['title']."'/>
        <h4>".getTranslationProduct($product->id)['title']."</h4></a></div>"];
       }

       return View("frontend.products.index",compact('products','markers','infoWindowContent'));
       }






    public function single(Request $request,$product_id,$slug){

 	   $product=Product::whereStatus(1)->findOrFail($product_id);
 	   $attribs=Attrib::where('product_id',$product->id)->get();
       
       $markers = [];  
       $infoWindowContent= []; 


          $markers[]=[$product->title];
        
        $url = url("/storage/products/".$product->image);
        $route = route("singleProduct",[$product->id,$product->slug]);
        $infoWindowContent[]=["<div class='detail_point'><a href='{$route}'><img src='{$url}' alt='".getTranslationProduct($product->id)['title']."'/>
        ".getTranslationProduct($product->id)['title']."</a></div>"];
  

     return View("frontend.products.single",compact('product','markers','infoWindowContent','attribs'));
    }




}
