<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\CategoriePost;
use App\Tag;
use App\Post;
use Toastr;

class BlogController extends Controller
{



      public function blog(Request $request){  
    	$posts = Post::latest()->paginate(8); 
       $this->vider_session($request);

    	return view('frontend.blogs.index', compact('posts'));}




      public function categorieBlog(Request $request,$categorie_id , $slug){
      	 $posts = CategoriePost::findOrFail($categorie_id)->posts()->paginate(4); 
          $this->vider_session($request);

         
       return view('frontend.blogs.index', compact('posts'));}




      public function tagBlog(Request $request,$tag_id , $slug){

      	$posts = Tag::findOrFail($tag_id)->posts()->paginate(4);
         $this->vider_session($request);


       return view('frontend.blogs.index', compact('posts'));}



          public function searchBlog(Request $request){
          if($request->q != ""){  
          $posts = Post::where('title', 'like','%'.$request->q.'%')
                        ->orWhere('description', 'like','%'.$request->q.'%')
                        ->paginate(100);
         $request->session()->put('search',$request->q);
                 
          return view('frontend.blogs.index',compact('posts'));     
        
         }else{
          return redirect()->route('blog');     
         }
               
         }

   
      public function vider_session($request)
      {
        $request->session()->put('search','');
      }




      public function showBlog($blog_id , $slug){
  	    $post = Post::findOrFail($blog_id);
    	return view('frontend.blogs.single', compact('post'));
        }





     public function NextPost($blog_id){  

             // get next post id
             $id_next = Post::where('id', '>', $blog_id)->min('id');
               if($id_next == null ){ return redirect()
                          ->route('showBlog',[$blog_id,Post::findOrFail($blog_id)->slug]); }

             $post=Post::findOrFail($id_next);
          return view('frontend.blogs.single', compact('post'));}
              


     public function PrevPost($blog_id){

           // get previous post id
           $id_previous =Post::where('id', '<', $blog_id)->max('id'); 
           if($id_previous == null ){ return redirect()
           	                           ->route('showBlog',[$blog_id,Post::findOrFail($blog_id)->slug]); }

           $post=  Post::findOrFail($id_previous);
           return view('frontend.blogs.single', compact('post')); 
        }   

     





}
