<?php

namespace App\Http\Controllers\Auth;


use Symfony\Component\HttpFoundation\Response;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Http\Request;
use App\Admin;
use Auth;
use Validator;
use Toastr;
use Carbon\Carbon;

class adminController extends Controller
{

  public function __construct()
    {
        $this->middleware('guest:admin')->except('logout');
            
            }



   public function showLoginForm()
    {
       return view('auth.adminLogin');
    }  



      public function login(Request $request){
         
                //validation
       $this->validate($request,[
           'email'=>'required|email',
           'password'=>'required','string'
                                ]);

         //time for  tarvalle the agent 
          $agent=Admin::whereEmail($request->email)->first();
          $day = Carbon::now()->format( 'l' );           
          $date= Carbon::now();             
          $hour= $date->format('H');

         //test si email existe
      if($agent){ 
          if($agent->status == 1){
                  //test is not admin
                  if(!$agent->is_admin == 1){ 
                      
                          //test time travelle
                          if( ( $hour+1 >= 18  || $hour+1 <= 7 || $hour == 0 ||  $day == "Sunday" )){ 
                                
                                 toastr()->error('message', 'does not allow authentication now');
                                 
                                 return redirect()->back()->withInput($request->only('email','remember'));
                                 //redirect because not allowd the travalle in the time
                             
                                }//end test time travelle
                         else{
                              $this->Authentifier($request);  }
                         
                  }//end test is not admin          

                    $this->Authentifier($request);
                    
              }//si compte disable
                else{
                 toastr()->error('your account is disabled, contact your admin.');       

              return redirect()->back()->withInput($request->only('email','remember'));
                }

          }//end si email existe       

          
           toastr()->error('mail ou password incorrect.'); 

        return redirect()->back()->withInput($request->only('email','remember'));}
      







      public function Authentifier(Request $request){

                 //Attemp to log the user in
     if(Auth::guard('admin')->attempt(['email'=>$request->email,'password'=>$request->password],$request->remember)){

            toastr()->success('Login With successfully.');
            return  redirect()->intended(route('admin.dashboard'));    

         }//end if
         
         }
      



 
  public  function logout(){
      Auth::guard('admin')->logout();
      
  return redirect('/');}


}
