<?php

namespace App\Http\Controllers\Admin\WebSetting;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\Facades\Image;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Input;
use Carbon\Carbon;
use App\Galerie;
use Session;
use DB;
use Validator;
use Toastr;

class GalerieController extends Controller
{


    

    public function index()
    {
        $galeries = Galerie::latest()->get();

        return view('admin.galerie.index', compact('galeries'));
    }




    public function create()
    {
        return view('admin.galerie.create');
    }



    public function store(Request $request)
    {

        $this->validate($request, [
            'titre'            => 'required|max:191|unique:galeries',
        ]);


        $images = $request->file('images');
        $imageNames = "";
        //upload images
        if (isset($images)) {

            //cree folder galeries
            if (!Storage::disk('public')->exists('galeries')) {
                Storage::disk('public')->makeDirectory('galeries');
            }
            //save this images in folder galeries     
            foreach ($images as $image) {

                $currentDate = Carbon::now()->toDateString();
                $imageName = $currentDate . '-' . uniqid() . '.' . $image->getClientOriginalExtension();


                  $img = Image::make($image->getRealPath())->resize(800,700);
                 $img->stream('png',100);
                Storage::disk('local')->put('public/galeries/' . $imageName, $img);

                $imageNames .= $imageName . '|';
            }
        } else {
            $imageNames = "default.png";
        }


        $galerie = new Galerie();

        $slug  = Str::slug($request->titre);
        $galerie->images = $imageNames;
        $galerie->titre = $request->titre;
        $galerie->slug = $slug;
        $galerie->description = $request->description;
        $galerie->videos = $request->videos;
        $galerie->status = $request->has('status') ? 1 : 0;
        $galerie->save();

        Toastr::success('message', 'Galerie created successfully.'); 
        return redirect('/admin/galerie');
    }




    

    public function deletePhoto(Request $request){
        
        $gallerie = Galerie::whereId($request->id_g)->firstOrFail();
        $images = explode('|', $gallerie->images);
        $new_imageNames = "";
        //delete image property
        for ($i = 0; $i <count($images)-1; $i++) {
            if ($images[$i] == $request->image) {

                if (Storage::disk('public')->exists('galeries/' .$images[$i])) {
                    Storage::disk('public')->delete('galeries/' .$images[$i]);
                }
            } else {
                $new_imageNames .= $images[$i] . '|';
            }
        }
        $gallerie->images = $new_imageNames;
        $gallerie->save();

        if($request->ajax()){ return response()->json(['msg' =>true]);
        }}













    public function edit($id)
    {
        $galerie = Galerie::findOrFail($id);
            return view('admin.galerie.edit', compact('galerie'));
    }



    public function update(Request $request, $id)
    {


        $this->validate($request, [
            'titre' => ['required', 'max:191', Rule::unique("galeries")->ignore($id)],
        ]);



        /* edite images*/
        $galerie = Galerie::findOrFail($id);
        $slug  = Str::slug($request->titre);
        $new_imageNames = "";

       /*add new Images */
        $images = $request->file('images');

        if (isset($images)) {

            //cree folder categoriegalerie
            if (!Storage::disk('public')->exists('galeries')) {
                Storage::disk('public')->makeDirectory('galeries');
            }
            //save this images in folder categoriegalerie     
            foreach ($images as $image) {

                $currentDate = Carbon::now()->toDateString();
                $imageName_new = $slug.'-'.$currentDate .'-'. uniqid() .'.'. $image->getClientOriginalExtension();


            $img = Image::make($image->getRealPath())->resize(800,700);
                 $img->stream('png',100);
                Storage::disk('local')->put('public/galeries/' . $imageName_new, $img);

                $new_imageNames .= $imageName_new . '|';
            }
        }
        /* end add new Images */


        
        $galerie->images.= $new_imageNames;
        $galerie->titre = $request->titre;
        $galerie->slug = $slug;
        $galerie->description = $request->description;
        $galerie->videos = $request->videos;
        $galerie->status = $request->has('status') ? 1 : 0;

        $galerie->save();

        
        Toastr::success('message', 'Galerie Update successfully.'); 
        return redirect('/admin/galerie/' . $id . '/edit');
    }





    public function destroy($id)
    {

        $galerie = Galerie::findOrFail($id);

        $images = explode('|', $galerie->images);

        //delete images
        for ($i = 0; $i < count($images) - 1; $i++) {

            if (Storage::disk('public')->exists('galeries/' . $images[$i])) {
                Storage::disk('public')->delete('galeries/' . $images[$i]);
            }
        }

        $galerie->delete();

        Toastr::success('message', 'Galerie deleted successfully.'); 
        return redirect('/admin/galerie');
    }



    public function enable($id) {

        $galeries = DB::table('galeries')->where('id',$id)->get();
        foreach ($galeries as $galerie) 
        {
            if ($galerie->status==1) 
            {
                DB::table('galeries')
                                    ->where('id', $id)
                                    ->update(['status' => 0]);

                                    Session::flash('success','galerie invisible');
            }
            else
            {
                 DB::table('galeries')
                                    ->where('id', $id)
                                    ->update(['status' => 1]);
                                    Session::flash('success','galerie visible');
            }
        }
            
            return redirect('/admin/galerie');
    }
}
