<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Storage;
use App\Objectmounthstats;

use Carbon\Carbon;
use App\Setting;
use App\Message;
use App\User;
use App\Admin;
use App\Post;
use App\Product;
use Auth;
use Hash;
use Toastr;
use DB;

class DashboardController extends Controller
{  

    public function index()
    {
        $tg = Product::count();

        return view('admin.dashboard', compact('tg'));

    }








    public function settings()
    {
        $settings = Setting::first();

        return view('admin.settings.setting',compact('settings'));
    }

    public function settingStore(Request $request)
    {

      //upload new  images
        $settings = Setting::first();
        if(!$settings){$settings=new Setting();}

        $settings->name   =$request->name ?? "";
        $settings->email   =$request->email ?? "";
        $settings->email2   =$request->email2 ?? "";
        $settings->fix   =$request->fix ?? "";
        $settings->phone   =$request->phone ?? "";
        $settings->address   =$request->address ?? "";
        $settings->footer   =$request->footer ?? "";
        $settings->facebook   =$request->facebook ?? "";
        $settings->twitter   =$request->twitter ?? "";
        $settings->instagram   =$request->instagram ?? "";
        $settings->save();
       

        Toastr::success('message', 'Updated successfully.');
        return back();
    }



    // MESSAGE
    public function message()
    {
        $messages = Message::get();

        return view('admin.settings.messages.index',compact('messages'));
    }

    public function messageRead($id)
    {
        $message = Message::whereId($id)->firstOrFail();

        return view('admin.settings.messages.readmessage',compact('message'));
    }

    public function messageReplay($id)
    {
        $message = Message::whereId($id)->firstOrFail();

        return view('admin.settings.messages.replaymessage',compact('message'));
    }

    public function messageSend(Request $request)
    {
        $request->validate([
            'agent_id'  => 'required',
            'user_id'   => 'required',
            'name'      => 'required',
            'email'     => 'required',
            'phone'     => 'required',
            'message'   => 'required'
        ]);

        Message::create($request->all());

        Toastr::success('message', 'Message send successfully.');
        return back();

    }

    public function messageReadUnread(Request $request)
    {
        $status = $request->status;
        $msgid  = $request->messageid;

        if($status){
            $status = 0;
        }else{
            $status = 1;
        }

        $message = Message::whereId($msgid)->firstOrFail();
        $message->status = $status;
        $message->save();

        return redirect()->route('admin.message');
    }


    public function messageDelete($id)
    {
        $message = Message::whereId($id)->firstOrFail();
        $message->delete();

        Toastr::success('message', 'Message deleted successfully.');
        return back();
    }

    public function contactMail(Request $request)
    {
        $message  = $request->message;
        $name     = $request->name;
        $mailfrom = $request->mailfrom;

        Mail::to($request->email)->send(new Contact($message,$name,$mailfrom));

        Toastr::success('message', 'Mail send successfully.');
        return back();
    }
    
}
