<?php

namespace App\Exceptions;

use Exception;
use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Illuminate\Support\Arr;

class Handler extends ExceptionHandler
{

    protected $dontReport = [
        //
    ];




    protected $dontFlash = [
        'password',
        'password_confirmation',
    ];


    public function report(Exception $exception)
    {
        parent::report($exception);
    }



    public function render($request, Exception $exception)
    {


        $class = get_class($exception);

        switch($class) {
            case 'Illuminate\Auth\AuthenticationException':
               $guard = Arr::get($exception->guards(), 0);
                switch ($guard) {
                  

                    case 'admin':
                        $login = 'admin/login';
                        break;
                    default:
                        $login = '/login';
                        break;    }
        
                return redirect($login);   }
    
    
       if ($this->isHttpException($exception)) {
        switch ($exception->getStatusCode()) {

            // not authorized
            case '403':
                return \Response::view('errors.errors-403',array(),403);
                break;

            // not found
            case '404':
                return \Response::view('errors.errors-404',array(),404);
                break;

/*            // internal error
            case '500':
                return \Response::view('errors.errors-500',array(),500);
                break;*/

            default:
                return $this->renderHttpException($exception);
                break;
        }
        }   


        
        return parent::render($request, $exception);   }





}
