@extends('frontend.layouts.app')

@section('title', 'MONOGRAPHIES ET DOCUMENTS')

@section('content')


<section class="breadcrumb-area" style="background-image: 
linear-gradient(to right bottom, rgba(113, 5, 36, 0.87), rgba(28, 114, 81, 0.78)), url({{asset('frontend/images/breadcrumb/cover02.jpg')}});">  <div class="container">
      <div class="row">
          <div class="col-xl-12">
              <div class="inner-content clearfix">
                  <div class="title">
                     <h1>Presse                    </h1>
                  </div>
                  <div class="breadcrumb-menu">
                      <ul class="clearfix">
                          <li><a href="/">Accueil</a></li>
                          <li class="active">Presse</li>
                      </ul>    
                  </div>
              </div>
          </div>
      </div>
  </div>
</section>



<section class="exhibitions-area exhibitions-page">
  <div class="container">
      <div class="row masonary-layout">
        @foreach($presses as $presse)
          <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
              <div class="single-exhibition-box style4">
                  <div class="img-holder">
                    <?php   $images=explode('|',$presse->images); ?>
          
                      @for($i=0; $i <@count($images)-1; $i++)
                      
                        @if($images)
                            <img src="{{asset('storage/presses/'.$images[$i])}}" class="img-responsive" >
                        @else
                            <img src="{{asset('notfound.png') }}" alt="{{getTranslationPresse($presse->id)['title']}}">
                        @endif
                        <div class="overlay-style-one bg1">
                            <div class="zoom-button">
                                <a class="lightbox-image" data-fancybox="gallery" href="{{asset('storage/presses/'.$images[$i])}}">
                                    <i class="fa fa-search-plus" aria-hidden="true"></i>
                                </a>
                            </div>
                        </div>
                      @endfor
                  </div>
                  <div class="text-holder text-center">
                      <h2>{{getTranslationPresse($presse->id)['title']}}</h2>
                  </div>   
              </div>    
          </div>
          @endforeach
      
      </div>
  </div>
</section>




@endsection

@section('scripts')

@endsection
