@extends('frontend.layouts.app')

@section('metatags')
<meta name="description" content="Unique Packing is a fruit export company, Who is deeply committed to provid fresh produce that contain higher nutritional values." />
<meta name="keywords" content="Unique, Packing, Fruit,export, Avocados, morocco" />
<meta name="copyright" content="Yacine Boughalem">
<meta name="url" content="{{route('singleProduct',[$product->id,$product->slug])}}">
<meta name="identifier-URL" content="{{route('singleProduct',[$product->id,$product->slug])}}">

<meta itemprop="image" content="/storage/products/{{$product->image}}" />
<meta property="og:image" itemprop="image/*" content="/storage/products/{{$product->image}}" />
<meta property="og:image:width" content="256" />
<meta property="og:image:height" content="256" />
<meta property="og:site_name" content="Unique Packing" />
@endsection
@section('title', getTranslationProduct($product->id)['title'])

@section('content')


    <div class="uniq--breadcrumb--area" style="background-image: linear-gradient(to right,
    rgba(27, 38, 105, 0.8),rgba(58, 182, 74, .4)),url('/storage/products/{{$product->image}}'); ">
        <div class="container">
            <div class="uniq--breadcrumb--area--content wow animated bounceInRight" data-wow-duration="1.5s" data-wow-delay=".1s">
                <h1 class="p-top-10">{{ getTranslationProduct($product->id)['title'] }}</h1>
            </div>
        </div>
        <img src="/assets/images/logo--shape.svg" class="shape--logo--01 wow animated bounceInRight" data-wow-duration="1.5s" data-wow-delay=".1s" />
    </div>







    @if ($product->style == 2)


        <section class="uniq--logistics--area p-top-40 p-bottom-40">
            <div class="container">
                @foreach ($attribs as $key => $attrib)
                    @if (($key + 1) % 2)
                        <div class="row  align-items-center">
                            <div class="col-md-7">
                                <div class="primary--title--small wow animated fadeInLeft" data-wow-duration="1.5s" data-wow-delay=".1s">
                                    <h3>
                                        {{ getTranslationAttrib($attrib->id)['title'] }}
                                    </h3>
                                </div>

                                <div class="t--paragraph--one p-top-40 wow animated fadeInLeft" data-wow-duration="1.5s" data-wow-delay=".1s">
                                    {!! getTranslationAttrib($attrib->id)['description'] !!}
                                </div>
                            </div>
                            <div class="col-md-5">
                                <?php $images = explode('|', $attrib->images); ?>
                                <div class="product-carousel owl-carousel owl-theme owl-nav-style-one  wow animated fadeInUp" data-wow-duration="1.5s" data-wow-delay=".1s">
                                              
                                                                              
                                   

                                  @for ($i = 0; $i < @count($images) - 1; $i++)
                                      @if (Storage::disk('public')->exists('attribs/' . $images[$i]))
                                            <div class="image--four">
                                              <img src="/storage/attribs/{{$images[$i]}}"
                                                  class="d-block w-100"
                                                  alt="{{ getTranslationAttrib($attrib->id)['title'] }}">
                                          </div>
                                      @endif
                                  @endfor

                              </div>
                            </div>
                        </div>
                    @else
                        <div class="row  align-items-center section--60">
                            <div class="col-md-5 ">
                                <?php $images = explode('|', $attrib->images); ?>
                                {{-- <div id="#owl-carousel" class="owl-carousel owl-theme"> --}}
                                  <div class="product-carousel owl-carousel owl-theme owl-nav-style-one wow animated fadeInUp" data-wow-duration="1.5s" data-wow-delay=".1s">
                                              
                                                                              
                                   

                                    @for ($i = 0; $i < @count($images) - 1; $i++)
                                        @if (Storage::disk('public')->exists('attribs/' . $images[$i]))
                                              <div class="image--four">
                                                <img src="/storage/attribs/{{$images[$i]}}"
                                                    class="d-block w-100"
                                                    alt="{{ getTranslationAttrib($attrib->id)['title'] }}">
                                            </div>
                                        @endif
                                    @endfor

                                </div>
                            </div>
                            <div class="col-md-7 order-first order-md-last">
                                <div class="primary--title--small wow animated fadeInLeft" data-wow-duration="1.5s" data-wow-delay=".1s">
                                    <h3>
                                        {!! getTranslationAttrib($attrib->id)['title'] !!}
                                    </h3>
                                </div>

                                <div class="t--paragraph--one p-top-40 wow animated fadeInLeft" data-wow-duration="1.5s" data-wow-delay=".1s">
                                    {!! getTranslationAttrib($attrib->id)['description'] !!}
                                </div>
                            </div>

                        </div>
                    @endif
                @endforeach




            </div>
        </section>

    @else
        <p>Oops</p>
    @endif


    <section class="uniq--form--area section--40 bg--02 ">
      <div class="container">
          <div class="row align-items-center">
              <div class="col-md-12">
                  <div class="primary--title--center--prim  wow animated bounceInLeft" data-wow-duration="1.5s" data-wow-delay=".1s">
                      <h2>Got Any Questions? Let Us Know!
                      </h2>
                  </div>
              </div>
          </div>
          <div class="row align-items-center justify-content-center p-top-20 wow animated fadeInUp" data-wow-duration="1.5s" data-wow-delay=".1s">
              <div class="col-md-6">
                <form  action="{{ route('log.message') }}" method="post" class="form" > 
                    @csrf
                        <input type="hidden" id="type" name="type" value="LOGISTICS" >
                    <div class="form-group">
                        <label for="name" class="form-label form-label--required">
                            @lang('uniqpacking.NAME')
                        </label>

                        <div class="form-addon" data-states-for="name">
                            <div class="form-addon__addon">
                                <span class="icon-name"></span>
                            </div>

                            <input type="text" id="name" name="name" class="form-input" placeholder="Full name" required>

                            <span class="form-addon__icon icon-valid"></span>
                            <span class="form-addon__icon icon-invalid"></span>
                        </div>

                       
                    </div>

                    <div class="form-group">
                        <label for="email" class="form-label form-label--required">
                            @lang('uniqpacking.EMAIL')
                        </label>

                        <div class="form-addon" data-states-for="email">
                            <div class="form-addon__addon">
                                <span class="icon-email"></span>
                            </div>

                            <input type="email" id="email" name="email" class="form-input" placeholder="Your Mail" required>

                            <span class="form-addon__icon icon-valid"></span>
                            <span class="form-addon__icon icon-invalid"></span>
                        </div>

                    </div>

                    <div class="form-group">
                        <label for="phone" class="form-label">
                            @lang('uniqpacking.PHONENUMBER')
                        </label>

                        <div class="form-addon" data-states-for="phone">
                            <div class="form-addon__addon">
                                <span class="icon-phone"></span>
                            </div>

                            <input type="text" id="phone" name="phone" class="form-input" >

                            <span class="form-addon__icon icon-valid"></span>
                            <span class="form-addon__icon icon-invalid"></span>
                        </div>

                    </div>

                    <div class="form-group">
                        <label for="company" class="form-label ">
                            @lang('uniqpacking.COMPANY_NAME')
                        </label>

                        <div class="form-addon" data-states-for="company">
                            <div class="form-addon__addon">
                                <span class="icon-name"></span>
                            </div>

                            <input type="text" id="company" name="company" class="form-input" placeholder="company" required>

                            <span class="form-addon__icon icon-valid"></span>
                            <span class="form-addon__icon icon-invalid"></span>
                        </div>

                       
                    </div>
                    <div class="form-group">
                        <label for="what" class="form-label form-label--required">
                            @lang('uniqpacking.WHATH_YOU_WANT')
                        </label>

                        <div class="form-addon" data-states-for="what">
                            <div class="form-addon__addon">
                                {{-- <span class="icon-name"></span> --}}
                                <i class="fa fa-user"></i>
                            </div>

                            <input type="text" id="what" name="what" class="form-input" placeholder="What you want to know? " >

                            <span class="form-addon__icon icon-valid"></span>
                            <span class="form-addon__icon icon-invalid"></span>
                        </div>

                      
                    </div>
                    <div class="form-group">
                        <label for="message" class="form-label form-label--required">
                            @lang('uniqpacking.MESSAGE')
                        </label>

                        <div class="form-addon" data-states-for="message">
                            <div class="form-addon__addon">
                                <span class="icon-name"></span>
                            </div>

                            <textarea type="text" id="message" name="message" class="form-input" placeholder="Write your message here..." required></textarea>

                            <span class="form-addon__icon icon-valid"></span>
                            <span class="form-addon__icon icon-invalid"></span>
                        </div>

                       
                    </div>


                    <div class="form-footer text-center">
                        <div class="button button-5 btn-auto">
                            <div id="circle"></div>
                            <button type="submit">@lang('uniqpacking.SUBMIT_NOW')</button>
                        </div>
                    </div>
                </form>
              </div>
          </div>
      </div>
  </section>

  @include('frontend/partials/subscribe')




@endsection

@section('scripts')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.js"></script>
    <script type="text/javascript">

function productCarousel () {
    if ($('.product-carousel').length) {
        $('.product-carousel').owlCarousel({
            dots: false,
            loop: true,
            margin: 8,
            nav: true,
            navText: ['<span class="fas fa-chevron-left fa-2x"></span>','<span class="fas fa-chevron-right fa-2x"></span>'],
            autoplayHoverPause: false,
            autoplay: 6000,
            smartSpeed: 1000,
            responsive:{
                0:{
                    items:1
                },
                600:{
                    items:1
                },
                800:{
                    items:1
                },
                1024:{
                    items:1
                },
                1100:{
                    items:1
                },
                1200:{
                    items:1
                },
                1300:{
                    items:1
                },
                1400:{
                    items:1
                }
            }
        });    		
    }
}

productCarousel();



  
        
    </script>

@endsection
