@extends('frontend.layouts.app')

@section('title', 'BLOG')

@section('content')

<style type="text/css">
  
  /* Styles for wrapping the search box */
.main {
    padding-top: 5px;
    width: 50%;
    margin: 1px 50px;
}

/* Bootstrap 4 text input with search icon */

.has-search .form-control {
    padding-left: 2.375rem;
}

.has-search .form-control-feedback {
    position: absolute;
    z-index: 2;
    display: block;
    width: 2.375rem;
    height: 2.375rem;
    line-height: 2.375rem;
    text-align: center;
    pointer-events: none;
    color: #aaa;
}


</style>

<section class="breadcrumb-area" style="background-image: 
linear-gradient(to right bottom, rgba(113, 5, 36, 0.87), rgba(28, 114, 81, 0.78)), url({{asset('frontend/images/breadcrumb/cover02.jpg')}});">  <div class="container">
      <div class="row">
          <div class="col-xl-12">
              <div class="inner-content clearfix">
                  <div class="title">
                     <h1>BLog
                    </h1>
                  </div>
                  <div class="breadcrumb-menu">
                      <ul class="clearfix">
                          <li><a href="/">Accueil</a></li>
                          <li class="active">Bblog</li>
                      </ul>    
                  </div>

                         <form action="{{ route('searchBlog') }}" method="GET"  class="form-search" accept-charset="utf-8">
                            @csrf
                          <div class="main">
                              <!-- Another variation with a button -->
                            <div class="input-group">
                              <input type="text" name="q" class="form-control" placeholder="Search this blog"/>
                              <div class="input-group-append">
                                <button class="btn btn-secondary" type="submit">
                                  <i class="fa fa-search"></i>
                                </button>
                              </div>
                            </div>
                          </div>
                        </form>

              </div>
          </div>
      </div>
  </div>
</section>


@if(count($posts) !=0 )
<section class="latest-blog-style3-area blog-page">
  <div class="container">
     
      <div class="row">
      <div class="col-xl-8 col-lg-8 col-md-8 col-sm-12">  
      <div class="row">      
        @foreach($posts  as $post)

          <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
              <div class="single-blog-post style3 wow fadeInLeft" data-wow-delay="0ms" data-wow-duration="1500ms">
                  <div class="img-holder">
                      <img src="{{asset('storage/posts/'.$post->image)}}" alt="Awesome Image">
                      <div class="overlay-style-one bg1"></div>
                  </div>
                  <div class="text-holder">
                      <div class="border-botton"></div>
                      <div class="post-date">
                          <span>{{$post->created_at->format('d-m-Y')}}</span>
                      </div>
                      <h3 class="blog-title"><a href="{{route('showBlog',[$post->id,$post->slug])}}">
                        {{getTranslationPost($post->id)['title']}}</a></h3>
                      <div class="text">{!!  substr(strip_tags(getTranslationPost($post->id)['description']), 0, 400) !!}....</div>
                      <div class="button-box">
                          <a href="{{route('showBlog',[$post->id,$post->slug])}}">Read More</a>
                      </div>
                  </div>
              </div>
          </div>
          @endforeach
          </div>   
        </div>

           <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12">       
          <!--Start sidebar Wrapper-->
          <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
              <div class="sidebar-wrapper">
                  <div class="single-sidebar">
                      <div class="title">
                          <h3>Categories</h3>
                      </div>
                      <ul class="categories clearfix">
                        @foreach($categoriesPost as $cat_post)
                          <li>
                            <a href="{{route('CategorieBlog',[$cat_post->id,$cat_post->slug])}}" title="{{$cat_post->posts->count()}}">
                                {{getTranslationCategoriePost($cat_post->id)['name']}} - ({{$cat_post->posts->count()}})
                            </a>
                          </li>
                         
                          @endforeach
                      </ul>
                  </div>


                  <div class="single-sidebar">
                    <div class="title">
                        <h3>Tags</h3>
                    </div>
                    <ul class="categories clearfix">
                        @foreach($tags as $tag)
                        <li>
                            <a href="{{route('TagBlog',[$tag->id,$tag->slug])}}" title="{{$tag->posts->count()}}">{{ getTranslationTag($tag->id)['name']}}</a>
                        </li>
                        @endforeach
                    </ul>
                </div>
             </div>
           </div>
         </div>



      <div class="row p-top-40">
        <div class="col-xl-12">
            <ul class="styled-pagination text-center">
                {{$posts->links()}}
            </ul>
        </div>
    </div>
      
  </div>
</section>

@endif








@endsection

@section('scripts')

@endsection
