@extends('frontend.layouts.app')

@section('title', 'CARTE INTÉRACTIVE DES GÉOSITES')

@section('content')

<section class="breadcrumb-area" style="background-image: 
linear-gradient(to right bottom, rgba(113, 5, 36, 0.87), rgba(28, 114, 81, 0.78)), url({{asset('frontend/images/breadcrumb/cover02.jpg')}});">  <div class="container">
      <div class="row">
          <div class="col-xl-12">
              <div class="inner-content clearfix">
                  <div class="title">
                     <h1>{{getTranslationMusee($musees->id)['title']}}
                    </h1>
                  </div>
                  <div class="breadcrumb-menu">
                      <ul class="clearfix">
                          <li><a href="index-2.html">Accueil</a></li>
                          <li class="active">{{getTranslationMusee($musees->id)['title']}}
                          </li>
                      </ul>    
                  </div>
              </div>
          </div>
      </div>
  </div>
</section>

<style>
  #map_wrapper {
    height: 500px;
    width: auto;
    border-top: 5px #327251 solid;
    margin-bottom: -60px;
  }

  #map_canvas {
      width: 100%;
      height: 100%;
  }

  .align-items-center {
    text-align: center!important;

  }

  em.fa.fa-inverse.fa-stack-1x {
    color: #000;
    border: 1px solid #000;
    border-radius: 50%;
}
</style>




      <section class="about-style1-area">
        <div class="container">
       
                    
                      <div class="row align-items-start">
                        <div class="col-xl-6 col-lg-12">
                          <div class="about-style1-content section-header text-left">
                            <div class="section-title-border">
                              <span>{{getTranslationMusee($musees->id)['title']}}</span>
                            </div>
                              
                              <div class="inner-content text-left">
                                  <div class="text">
                                  {!! getTranslationMusee($musees->id)['description'] !!}
                                  </div>
                              </div>    
                          </div>   
                      </div>
                          <div class="col-xl-6 col-lg-10">
                            <div class="about-style1-left-content clearfix">
                              <div class="recent-post">
                                <div class="recent-post-carousel owl-carousel owl-theme owl-nav-style-one">
                                              
                                    <?php   $images=explode('|',$musees->images); ?>
                                    @for($i=0 ; $i<@count($images)-1 ; $i++)      
                                    @if(Storage::disk('public')->exists('musees/'.$images[$i]))
                                    <div class="single-recent-post">
                                        <div class="img-holder">
                                            <img src="{{asset('storage/musees/'.$images[$i])}}" alt="{{getTranslationMusee($musees->id)['title']}}">
                                            <div class="overlay-style-one bg1"></div>
                                        </div>
                                    </div>
                                    @endif
                                    @endfor                  

                                </div> 
                              </div>
                            </div>     
                          </div>
                          
                          
                      </div> 
                   
                          <!-- ======================================== -->
                      <div class="row align-items-center">
                            <div class="col-xl-6 col-lg-10">
                              <div class="about-style1-left-content clearfix">
                                <div class="recent-post">
                                  <div class="recent-post-carousel owl-carousel owl-theme owl-nav-style-one">
                                                
                                      <?php   $image2=explode('|',$musees->image2); ?>
                                      @for($i=0 ; $i<@count($image2)-1 ; $i++)      
                                      @if(Storage::disk('public')->exists('musees/'.$image2[$i]))
                                      <div class="single-recent-post">
                                          <div class="img-holder">
                                              <img src="{{asset('storage/musees/'.$image2[$i])}}" alt="{{getTranslationMusee($musees->id)['title']}}">
                                              <div class="overlay-style-one bg1"></div>
                                          </div>
                                      </div>
                                      @endif
                                      @endfor       

                                  </div> 
                                </div>
                              </div>     
                          </div>

                          <div class="col-xl-6 col-lg-12">
                            <div class="about-style1-content section-header text-left">
                              <div class="section-title-border">
                                <span>{{getTranslationMusee($musees->id)['title']}}</span>
                                <h1>{{getTranslationMusee($musees->id)['title2']}}</h1>
                              </div>
                                
                                <div class="inner-content text-left">
                                    <div class="text">
                                      {!! getTranslationMusee($musees->id)['description2'] !!}
                                    </div>
                                </div>    
                            </div>   
                        </div>  
                          
                      </div> 



                      <div class="row align-items-center p-top-60">

                      <div class="col-xl-12 col-lg-12">
                        <div class="about-style1-content section-header text-center">
                          <div class="section-title-border">
                            <span>{{getTranslationMusee($musees->id)['title']}}</span>
                            <h1>{{getTranslationMusee($musees->id)['title3']}}</h1>
                          </div>
                            
                            <div class="inner-content text-left">
                                <div class="text">
                                  {!! getTranslationMusee($musees->id)['description3'] !!}
                                </div>
                            </div>    
                        </div>   
                    </div>  
                      
                  </div> 
              
   
        </div>    
      </section>









    <!-- map -->
    <section class="about-style2-area">
      <div class="container">
          <div class="row align-items-center justify-content-center">
            
              <div class="col-xl-6 col-lg-12">
                  <div class="about-style1-content section-header">
                    <div class="section-title-border">
                      <h1>{{getTranslationMusee($musees->id)['title']}}</h1>
                    </div>
                  </div>   
              </div>
          </div> 
      </div>    

      <div id="map_wrapper" class="map-canvas">
        <div id="map_canvas" class="mapping"></div>
    </div>
    </section>










@endsection

@section('scripts')



@endsection
