@extends('backend.layouts.app')

@section('title', 'Settings')

@push('styles')

@endpush


@section('content')

    <div class="block-header"></div>

    <div class="row clearfix">

        <div class="col-xs-12">
            <div class="card">
                <div class="header bg-white">
                    <h2>
                      <i class="material-icons">settings</i>   GENERAL SETTING
                    </h2>
                </div>
                <div class="body">
                    <form action="{{url('admin/settings')}}" method="POST" enctype="multipart/form-data">
                        @csrf

                   <div class="form-group form-float" hidden="true">
                    <label class="form-label">Logo over the Image Property</label>
                        <div class="form-line">
                            <input type="file" class="form-control" name="logo" value="{{ ($settings ? $settings->logo : '' )}}" accept="image/*">
                            <img src="{{asset('storage/logo/'.($settings ? $settings->logo : '' ))}}" />
                        </div>
                  </div>      
                                      
                    

                        <div class="form-group">
                            <label class="form-label">Titre de Site Web </label>
                            <div class="form-line">
                                <input type="text" name="name" class="form-control" value="{{  ( $settings ? $settings->name : '') }}">
                                
                            </div>
                        </div>
                        <div class="form-group form-float">
                            <label class="form-label">Email</label>
                            <div class="form-line">
                                <input type="email" name="email" class="form-control" value="{{  ( $settings ? $settings->email : '') }}">
                                
                            </div>
                        </div>
                        <div class="form-group form-float">
                            <label class="form-label">Email2</label>
                            <div class="form-line">
                                <input type="email" name="email2" class="form-control" value="{{  ( $settings ? $settings->email2 : '') }}">
                                
                            </div>
                        </div>
                        <div class="form-group form-float">
                            <label class="form-label">Tél</label>
                            <div class="form-line">
                                <input type="text" name="phone" class="form-control" value="{{  ( $settings ? $settings->phone : '') }}">
                                
                            </div>
                        </div>
                        <div class="form-group form-float">
                            <label class="form-label">Fix</label>
                            <div class="form-line">
                                <input type="text" name="fix" class="form-control" value="{{  ( $settings ? $settings->fix : '') }}">
                                
                            </div>
                        </div>

                        <div class="form-group form-float">
                            <label class="form-label">Adresse</label>
                            <div class="form-line">
                                <input type="text" name="address" class="form-control" value="{{  ( $settings ? $settings->address : '') }}">
                            </div>
                        </div>
                        <div class="form-group form-float" >
                            <label class="form-label">Footer</label>
                            <div class="form-line">
                                <input type="text" name="footer" class="form-control" value="{{  ( $settings ? $settings->footer : '') }}">
                            </div>
                        </div>

                        <div class="form-group form-float">
                            <label class="form-label"><i class="material-icons">http</i> Facebook Handler</label>
                            <div class="form-line">
                                <input type="url" name="facebook" class="form-control" value="{{  ( $settings ? $settings->facebook : '') }}" placeholder="http://....">
                            </div>
                        </div>
                        <div class="form-group form-float">
                            <label class="form-label"><i class="material-icons">http</i> Twitter Handler</label>
                            <div class="form-line">
                                <input type="url" name="twitter" class="form-control" value="{{  ( $settings ? $settings->twitter : '') }}" placeholder="http://....">
                            </div>
                        </div>
                        <div class="form-group form-float">
                            <label class="form-label"><i class="material-icons">http</i> Instagram Handler</label>
                            <div class="form-line">
                                <input type="url" name="instagram" class="form-control" value="{{  ( $settings ? $settings->instagram : '') }}" placeholder="http://....">
                            </div>
                        </div>

                        <button type="submit" class="btn btn-indigo btn-block btn-lg m-t-15 waves-effect">
                            <i class="material-icons">save</i>
                            <span>SAVE</span>
                        </button>

                    </form>
                    
                </div>
            </div>
        </div>

    </div>

@endsection


@push('scripts')


@endpush
