@extends('backend.layouts.app')

@section('title', 'Create Post')

@push('styles')

    <link rel="stylesheet" href="{{asset('backend/plugins/bootstrap-select/css/bootstrap-select.css')}}">

@endpush


@section('content')

  <div class="block-header">
        <ol class="breadcrumb breadcrumb-col-pink">
                                <li><a href="/admin"><i class="material-icons">home</i> Home</a></li>
                                <li><a href="{{route('admin.post.index')}}"><i class="material-icons">description</i> Post </a></li>
                                <li class="active"><i class="material-icons">add</i>Add Post</li>
                            </ol>
    </div>

    <div class="block-header"></div>

    <div class="row clearfix">
        <form action="{{route('admin.post.store')}}" method="POST" enctype="multipart/form-data" id="form_validation"  novalidate="novalidate">
        @csrf
        <div class="col-lg-8 col-md-4 col-sm-12 col-xs-12">
            <div class="card">
                <div class="header">
                    <h2>CREATE POST</h2>
                </div>
                <div class="body">

                    <div class="form-group form-float">
                        <div class="form-line">
                            <input type="text" name="title" class="form-control" value="{{old('title')}}" required="">
                            <label class="form-label">Post Title</label>
                        </div>
                    </div>

                    <div class="form-group">
                        <input type="checkbox" id="published" name="status" class="filled-in" value="1" />
                        <label for="published">Published</label>
                    </div>
                    <hr>
                    <div class="form-group">
                        <label for="">Body</label>
                        <textarea name="description" id="tinymce">{{old('body')}}</textarea>
                    </div>

                </div>
            </div>
        </div>
        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
            <div class="card">
                <div class="header">
                    <h2>SELECT CATEGORY</h2>
                </div>
                <div class="body">

                    <div class="form-group form-float">
                        <div class="form-line">
                            <label>Select Category</label>
                            <u><a href="{{route('admin.categoriePost.create')}}" title="Add new CategoriePost" target="_blanck">Ajouter nouveau</a></u>
                            <select name="categories[]" class="form-control show-tick" multiple required="">
                                @foreach($categories as $category)
                                    <option value="{{$category->id}}">{{$category->name}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="form-group form-float">
                        <div class="form-line">
                            <label>Select Tag</label>
                            <u><a href="{{route('admin.tag.create')}}" title="Add new tag" target="_blanck">Ajouter nouveau</a></u>
                            <select name="tags[]" class="form-control show-tick" multiple required="">
                                @foreach($tags as $tag)
                                    <option value="{{$tag->id}}">{{$tag->name}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    
                         <div class="form-group">
                                   <label class="col-form-label"> <strong style="color:black"> Image  </strong> :</label>               
                                                <div class="form-group form-float">
                                                    <input type="file" name="image" id="profile-image-input" style="display:none;" accept="image/*">
                                                    <button type="button" class="btn bg-white btn-sm waves-effect m-t-15" id="profile-image-btn">
                                                        <i class="material-icons" style="color:black">image</i>
                                                        <span style="color:black">UPLOAD IMAGE</span>
                                                    </button><br><br>
                                                   
                                               </div>
                                     </div>

                                           <div class="form-group">
                                             <img src="" id="profile-imgsrc" class="img-responsive" style="width:130px;height:130px;display: none;">
                                           </div>


                    <button type="submit" class="btn btn-indigo btn-lg m-t-15 waves-effect">
                        <i class="material-icons">save</i>
                        <span>SAVE</span>
                    </button>

                </div>
            </div>
        </div>
        </form>
    </div>

@endsection


@push('scripts')

    <script src="{{ asset('backend/plugins/bootstrap-select/js/bootstrap-select.js') }}"></script>
    <script src="{{asset('backend/plugins/tinymce/tinymce.js')}}"></script>
 
      <!-- validation -->
      <script src="{{ asset('backend/plugins/jquery-validation/jquery.validate.js')}}"></script>
        <!-- Custom Js -->
       <script src="{{ asset('backend/js/pages/forms/form-validation.js')}}"></script>


    <script>
        $(function () {
            tinymce.init({
                selector: "textarea#tinymce",
                theme: "modern",
                height: 300,
                plugins: [
                    'advlist autolink lists link image charmap print preview hr anchor pagebreak',
                    'searchreplace wordcount visualblocks visualchars code fullscreen',
                    'insertdatetime media nonbreaking save table contextmenu directionality',
                    'emoticons template paste textcolor colorpicker textpattern imagetools'
                ],
                toolbar1: 'insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image',
                toolbar2: 'print preview media | forecolor backcolor emoticons',
                image_advtab: true
            });
            tinymce.suffix = ".min";
            tinyMCE.baseURL = '{{asset('backend/plugins/tinymce')}}';
        });
    </script>



<script>
    $(function(){
        function showImage(fileInput,imgID){
            if (fileInput.files[0]) {
                var reader = new FileReader();
                reader.onload = function(e){
                    $(imgID).attr('src',e.target.result);
                    $(imgID).attr('alt',fileInput.files[0].name);
                }
                reader.readAsDataURL(fileInput.files[0]);
            }
        }
        $('#profile-image-btn').on('click', function(){
            $('#profile-image-input').click();
        });
        $('#profile-image-input').on('change', function(){
            showImage(this, '#profile-imgsrc');
    
    var img = document.getElementById('profile-imgsrc');
    img.style.display = 'block';

        });
    })
</script>

@endpush
