@extends('backend.layouts.app')

@section('title', 'Videos')

@section('content')

    <div class="block-header">
        <ol class="breadcrumb breadcrumb-col-pink">
                                <li><a href="/admin"><i class="material-icons">home</i> Home</a></li>
                                <li class="active"><i class="material-icons">receipt</i> Videos</li>
                            </ol>
    </div>

    <div class="row clearfix">

        <div class="col-lg-12">
        </div>

        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
            <div class="card">
                <div class="header">
                    <h2>
                        <strong style="color:black">Videos List</strong>
                    </h2>

        <ul class="header-dropdown m-r--5">
                     <li class="dropdown">
     <a href="{{route('admin.video.create')}}" class="btn bg-indigo btn-circle waves-effect waves-circle waves-float waves-light">
        <i class="material-icons left" style="color:#fff">add</i></a>
                      </li>
                      </ul>

                </div>
                <div class="body table-responsive">
                    <table class="table">
                        <thead>
                            <tr style="background-color:#E9FAF0">
                        <th>#</th>
                        <th width="150px">Image</th>
                        <th>Title</th>
                        <th>Status</th>
                        <td class="text-center">
                            
                            </tr>
                        </thead>
                        <tbody>
 

                     @foreach($videos as $video)
                        <tr>
                            <th>{{$video->id}}</th>
                           <td><img src="{{asset('storage/videos/'.$video->img)}}" width="40px" height="40px"></td>
                           <td>{{$video->title}}</td>
                                    
                                        <td>
                                    <a href="{{url('admin/video/enable/'.$video->id)}}" class="badge {{$video->status == true ? 'bg-green' : 'bg-pink '}}">{{$video->status == true ? 'On' : 'Off'}}</a>
                                  </td>             
                    
                                    <td class="text-center">
                                        <a href="{{route('admin.video.edit',$video->id)}}" class="btn btn-info btn-sm waves-effect">
                                            <i class="material-icons">edit</i>
                                        </a>
                                        <button type="button" class="btn btn-danger btn-sm waves-effect" onclick="deletevideo({{$video->id}})">
                                            <i class="material-icons">delete</i>
                                        </button>

                                        <form action="{{route('admin.video.destroy',$video->id)}}" method="POST" id="del-video-{{$video->id}}" style="display:none;">
                                            @csrf
                                            @method('DELETE')
                                        </form>

                                    </td>

                                </tr>

                            @endforeach
                            
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>



@endsection



@push('scripts')

    <script>
        function deletevideo(id){
            
            swal({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.value) {
                    document.getElementById('del-video-'+id).submit();
                    swal(
                    'Deleted!',
                    'video has been deleted.',
                    'success'
                    )
                }
            })
        }
    </script>


@endpush