@extends('backend.layouts.app')

@section('title', 'Galleries')

@section('content')

    <div class="block-header">
        <ol class="breadcrumb breadcrumb-col-pink">
                                <li><a href="/admin"><i class="material-icons">home</i> Home</a></li>
                                <li class="active"><i class="material-icons">photo_library</i> Galleries</li>
                            </ol>
    </div>


    <div class="row clearfix">

        <div class="col-lg-12">
        </div>

        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
            <div class="card">
                <div class="header">
                    <h2>
                        <strong style="color:black">Galerie List</strong>
                    </h2>

          <ul class="header-dropdown m-r--5">
                     <li class="dropdown">
     <a href="{{route('admin.galerie.create')}}" class="btn bg-indigo btn-circle waves-effect waves-circle waves-float waves-light">
        <i class="material-icons left" style="color:#fff">add</i></a>
                      </li>
                      </ul>
                       
                    </ul>
                </div>
                <div class="body table-responsive">
                    <table class="table">
                        <thead>
                            <tr style="background-color:#E9FAF0">
                        <th>#</th>
                        <th width="150px">Image</th>
                        <th>Title</th>
                        <th>Status</th>
                        <th class="text-center">Action</th>
                            
                            </tr>
                        </thead>
                        <tbody>
 

                     @foreach($galeries as $galerie)
                        <tr>
                            <th>{{$galerie->id}}</th>

                                <?php   $image=explode('|',$galerie->images); ?>
                           <td><img src="{{asset('storage/galeries/'.$image[0])}}" width="40px" height="40px"></td>
                           <td>{{$galerie->titre}}</td>
                            <td>
                                
                                @if($galerie->status == true)
                                <a  href="{{url('admin/galerie/enable/'.$galerie->id.'')}}"  > <span class="badge bg-green">active</span> 
                                </a>
                            @else
        
                                <a  href="{{url('admin/galerie/enable/'.$galerie->id.'')}}" ><span class="badge bg-red">inactive</span> 
                                </a>
                            @endif </td>                 
                    
                                    <td class="text-center">

                                      <a href="/admin/galerie/{{$galerie->id}}/edit" class="btn btn-primary   waves-effect"><i class="material-icons">mode_edit</i></a>

                                          <button type="button" class="btn btn-danger btn-sm waves-effect" onclick="deleteGalerie({{$galerie->id}})">
                                            <i class="material-icons">delete</i>
                                        </button>

                                    <form action="/admin/galerie/{{$galerie->id}}" method="POST" id="del-galerie-{{$galerie->id}}"  style="display: none;">
                                        @csrf
                                        @method('DELETE')
                                        <input name="_method" type="hidden" value="DELETE">
                                     </form>
                                  
                                    
                                    </td>
                                </tr>

                            @endforeach
                            
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>



@endsection



@push('scripts')

    <script>
        function deleteGalerie(id){
            
            swal({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.value) {
                    document.getElementById('del-galerie-'+id).submit();
                    swal(
                    'Deleted!',
                    'galerie has been deleted.',
                    'success'
                    )
                }
            })
        }
    </script>


@endpush