<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateGaleriesTranslationsTable extends Migration
{
    
    
    public function up()
    {
        Schema::create('galeries_translations', function (Blueprint $table) {
            
            $table->increments('id');
            $table->unsignedInteger('galerie_id');
            $table->string('locale')->index();

            $table->string('titre')->unique();
            $table->text('description')->nullable();

            $table->softDeletes();
            $table->timestamps();
            $table->foreign('galerie_id')->references('id')->on('galeries')->onDelete('cascade');
        });
    }





    public function down()
    {
        Schema::dropIfExists('galeries_translations');
    }
}
