<?php

namespace App\Http\Controllers\Admin;

use App\Banner;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\Facades\Image;
use Carbon\Carbon;
use Session;
use Illuminate\Validation\Rule;
use DB;

class BannerController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth:admin');
    }



    public function index()
    {
        $banners = Banner::all();
        return view('admin.banner.index', compact('banners'));
    }



    public function create()
    {
        return view('admin.banner.create');
    }


    public function store(Request $request)
    {
        $this->validate($request, [
            'title' => 'required|max:191|unique:banners',
            'subtitle' => 'required|max:191',
            'photo' => 'required|image|mimes:jpeg,jpg,png',
        ]);


        $photo = $request->file('photo');
        //dd($photo);
        //upload image
        if (isset($photo)) {

            //cree folder banners
            if (!Storage::disk('public')->exists('banners')) {
                Storage::disk('public')->makeDirectory('banners');
            }
            //save this image in folder banners     

            $currentDate = Carbon::now()->toDateString();
            $photoName = $currentDate . '-' . uniqid() . '.' . $photo->getClientOriginalExtension();


            $img = Image::make($photo->getRealPath());
            $img->stream(); // <-- Key point
            Storage::disk('local')->put('public/banners/' . $photoName, $img);
        } else {
            $photoName = "default.png";
        }
        //dd($photoName);

        //new categorie
        $banner = new Banner();
        $banner->title = $request->title;
        $banner->subtitle = $request->subtitle;
        $banner->photo = $photoName;
        $banner->save();

        Session::flash('msg', 'Votre Banner a été bien passer');
        return redirect('/admin/banner');
    }





    public function edit($id)
    {
        $banners = Banner::find($id);
        return view('admin.banner.edit', compact('banners'));
    }

    



    public function update(Request $request, $id)
    {
        //validation
        $this->validate($request, [
            'title' => ['required','max:191',Rule::unique("banners")->ignore($id)],
            'subtitle' => 'required', 'max:191',
            'photo' => 'image|mimes:jpeg,jpg,png',
        ]);


        $banner = Banner::find($id);

        //upload new  images
        $photo = $request->file('photo');
        //upload image
        if (isset($photo)) {

            $currentDate = Carbon::now()->toDateString();
            $photoName = $currentDate . '-' . uniqid() . '.' . $photo->getClientOriginalExtension();

            //cree new folder si not existe
            if (!Storage::disk('public')->exists('banners')) {
                Storage::disk('public')->makeDirectory('banners');
            }

            // delete old image
            if (Storage::disk('public')->exists('banners/' . $banner->photo)) {
                Storage::disk('public')->delete('banners/' . $banner->photo);
            }

            $img = Image::make($photo->getRealPath());
            $img->stream();// <-- Key point

            Storage::disk('local')->put('public/banners/' . $photoName, $img);

            $banner->photo = $photoName;
        }

        //update banner
        $banner->title = $request->title;
        $banner->subtitle = $request->subtitle;

        $banner->save();


        session()->flash('success', 'Votre Update Banner a été bien passer');

        return redirect('/admin/banner');
    }

   

    public function destroy($id)
    {
        $banner = Banner::find($id);

        //delete images
                  
       if(Storage::disk('public')->exists('banners/'.$banner->photo)){
              Storage::disk('public')->delete('banners/'.$banner->photo);    }
           
           $banner->delete();
  
          Session::flash('msg', 'Votre delete a été bien passer'); 
        
        $banners = Banner::all();
        return view('admin.banner.index', compact('banners'));
    }




    public function enable($id) {

        $banners = DB::table('banners')->where('id',$id)->get();
        foreach ($banners as $banner) 
        {
            if ($banner->status==1) 
            {
                DB::table('banners')
                                    ->where('id', $id)
                                    ->update(['status' => 0]);

                                    Session::flash('success','Banner invisible');
            }
            else
            {
                 DB::table('banners')
                                    ->where('id', $id)
                                    ->update(['status' => 1]);
                                    Session::flash('success','Banner visible');
            }
        }
            
            return redirect('/admin/banner');
    }

}
