<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\Facades\Image;
use Illuminate\Support\Str;
use Carbon\Carbon;
use App\Setting;
use App\Message;
use App\Admin;
use App\User;
use Toastr;
use Auth;
use Hash;

class AdminController extends Controller
{  





    public function index()
    {
         $admins = Admin::orderBy('is_admin','DESC')->whereNotIn('id',[Auth::id()])->get();      
        return view('admin.admins.index',compact('admins'));

    }



    public function create()
    {
            return view('admin.admins.create');

    }


     public function store(Request $request)
    {
                      //validation
              //validation
    $this->validate($request, [
            'name'      => 'required',
            'username'  => ['required','unique:admins'],
            'email'     => ['required', 'string', 'email', 'max:255','unique:admins'],
            'image'     => 'max:2048|image|mimes:jpeg,jpg,png',
            'password' => 'required|string|min:6|confirmed',
            'about'     => 'max:250'
           
        ],[
            'image.max'=>'The image may not be greater than 2048 kilobytes =2Mo',
                ]);
 

      //upload new  images
       $image= $request->file('image');
       $slug  = Str::slug($request->name);
       //upload image
        if(isset($image)){

            $currentDate = Carbon::now()->toDateString();
            $imageName= $currentDate.'-'.uniqid().'.'.$image->getClientOriginalExtension();
            
            //cree new folder si not existe
            if(!Storage::disk('public')->exists('admins')){
                Storage::disk('public')->makeDirectory('admins');
            }

            $img = Image::make($image->getRealPath());
            $img->stream(); // <-- Key point
            Storage::disk('local')->put('public/admins/'.$imageName, $img);
            
        } else{
             $imageName='default.png';
        }

         //update user
        $admin=new Admin();

        $admin->name = $request->name;
        $admin->username = $request->username;
        $admin->email = $request->email;
        $admin->image = $imageName;
        $admin->about = $request->about;
        $admin->password = bcrypt($request->password);
        $admin->is_admin = $request->has('is_admin')?1:0;
        $admin->status = $request->has('status')?1:0;
        $admin->save();

          Toastr::success('message', 'Create with successful.');
        return redirect()->route('admin.comptes.index');

    }







    public function enable($id)
    {  
        $admin =Admin::whereId($id)->firstOrFail();

            if ($admin->status== 1){

                    Admin::whereId($id)->update(['status' => 0]);
                    Toastr::success('message', 'élement invisible.');  }
            
            else{
                 Admin::whereId($id)->update(['status' => 1]);
                 Toastr::success('message', 'élement invisible.');    }
            
            return redirect()->route('admin.comptes.index');
    }








    public function edit($id)
    {
          $admin = Admin::findOrFail($id);
        return view('admin.admins.edit',compact('admin'));

    }



    public function update(Request $request, $id)
    {
              //validation
    $this->validate($request, [
            'name'      => 'required',
            'username'  => ['required', 'string','max:255',Rule::unique("admins")->ignore($id)],
            'email'     => ['required', 'string', 'email', 'max:255',Rule::unique("admins")->ignore($id)],
            'image'     => 'max:2048|image|mimes:jpeg,jpg,png',
            'about'     => 'max:250'
           
        ],[
            'image.max'=>'The image may not be greater than 2048 kilobytes =2Mo',
                ]);
 

         $admin = Admin::findOrFail($id);

      //upload new  images
       $image= $request->file('image');
       $slug  = Str::slug($request->name);

       if(isset($image)){
            $currentDate = Carbon::now()->toDateString();
            $imagename = $slug.'-admin-'.Auth::id().'-'.$currentDate.'.'.$image->getClientOriginalExtension();

            if(!Storage::disk('public')->exists('admins')){
                Storage::disk('public')->makeDirectory('admins');
            }
            if(Storage::disk('public')->exists('admins/'.$admin->image) && $admin->image != 'default.png' ){
                Storage::disk('public')->delete('admins/'.$admin->image);
            }
            $adminimage = Image::make($image->getRealPath());
            $adminimage->stream();
            Storage::disk('public')->put('admins/'.$imagename, $adminimage);
            
        }else{
            $imagename = $admin->image;
        }

       if($request->password){
        
               $this->validate($request, [
                   'password' => 'required|string|min:6|confirmed',
               ]);

               $admin->password = bcrypt($request->password);
           }
         //update admin
        $admin->name = $request->name;
        $admin->username = $request->username;
        $admin->email = $request->email;
        $admin->image = $imagename;
        $admin->about = $request->about;
        $admin->is_admin = $request->has('is_admin')?1:0;
        $admin->status = $request->has('status')?1:0;
        $admin->save();

         Toastr::success('message', 'update with successful.');
        return redirect()->route('admin.comptes.index');

    }



    public function destroy(Request $request,$id)
    {
        $admin=Admin::findOrFail($id);
        $admin->delete();

        if (Storage::disk('public')->exists('admins/' . $admin->image)) {
                    Storage::disk('public')->delete('admins/' . $admin->image);
                }
        Toastr::success('message', 'Deleted successfully.');
        return redirect()->route('admin.comptes.index');
    }





    public function changePasswordUpdate(Request $request)
    {
        if (!(Hash::check($request->get('currentpassword'), Auth::user()->password))) {

            Toastr::error('message', 'Your current password does not matches with the password you provided! Please try again.');
             return redirect()->back()->withInput($request->only('newpassword','newpassword_confirmation'));
        }


        if(strcmp($request->get('currentpassword'), $request->get('newpassword')) == 0){

            Toastr::error('message', 'New Password cannot be same as your current password! Please choose a different password.');
            return redirect()->back()->withInput($request->only('currentpassword'));
        }

        $this->validate($request, [
            'currentpassword' => 'required',
            'newpassword' => 'required|string|min:6|confirmed',
        ]);

        $user = Auth::user();
        $user->password = bcrypt($request->get('newpassword'));
        $user->save();

        Toastr::success('message', 'Password changed successfully.');
        return redirect()->back();
    }


    public function profile()
    {
        $profile = Auth::user();

        return view('admin.admins.profile',compact('profile'));
    }

    public function profileUpdate(Request $request)
    {
        $request->validate([
            'name'      => 'required',
            'username'  => 'required',
            'email'     => 'required|email',
            'image'     => 'image|mimes:jpeg,jpg,png',
            'about'     => 'max:250'
        ]);

        $user = Admin::find(Auth::id());

        $image = $request->file('image');
        $slug  = Str::slug($request->name);

        if(isset($image)){
            $currentDate = Carbon::now()->toDateString();
            $imagename = $slug.'-admin-'.Auth::id().'-'.$currentDate.'.'.$image->getClientOriginalExtension();

            if(!Storage::disk('public')->exists('admins')){
                Storage::disk('public')->makeDirectory('admins');
            }
            if(Storage::disk('public')->exists('admins/'.$user->image) && $user->image != 'default.png' ){
                Storage::disk('public')->delete('admins/'.$user->image);
            }
            $userimage = Image::make($image->getRealPath());
            $userimage->stream();
            Storage::disk('public')->put('admins/'.$imagename, $userimage);
            
        }else{
            $imagename = $user->image;
        }

        $user->name = $request->name;
        $user->username = $request->username;
        $user->email = $request->email;
        $user->image = $imagename;
        $user->about = $request->about;

     Toastr::success('message', 'Profile changed successfully.');
        $user->save();

        return back();
    }

}
