@extends('frontend.layouts.app')

@section('title', 'LES ÉVÉNEMENTS')

@section('content')


<section class="breadcrumb-area" style="background-image: 
linear-gradient(to right bottom, rgba(113, 5, 36, 0.87), rgba(28, 114, 81, 0.78)), url({{asset('frontend/images/breadcrumb/cover02.jpg')}});">  <div class="container">
      <div class="row">
          <div class="col-xl-12">
              <div class="inner-content clearfix">
                  <div class="title">
                     <h1>LES ÉVÉNEMENTS
                    </h1>
                  </div>
                  <div class="breadcrumb-menu">
                      <ul class="clearfix">
                          <li><a href="index-2.html">Accueil</a></li>
                          <li class="active">ÉVÉNEMENTS</li>
                      </ul>    
                  </div>
              </div>
          </div>
      </div>
  </div>
</section>


<section class="events-style3-area" style="background: url('https://riad-milouda.com/front/newassets/images/bg3.png'); background-size: cover">
  
  <div class="container">
      <div class="row">
          <div class="col-xl-12">
              <!--Start Single event Box Style3-->
              <div class="single-event-box-style2">
                  <div class="row">

                    @foreach($events  as $event)
                      <div class="col-md-6">
                          <div class="single-event-box p-top-30 m-bottom-30">
                            <div class="img-holder">
                                <div class="inner">
                                      
                                      @if(Storage::disk('public')->exists('events/'.$event->img))
                                            <img src="{{asset('storage/events/'.$event->img)}}" alt="{{ getTranslationEvent($event->id)['title'] }}">
                                      @elseif(Storage::disk('public')->exists('agendas/'.$event->img))
                                            <img src="{{asset('storage/agendas/'.$event->img)}}" alt="{{ getTranslationEvent($event->id)['title'] }}">
                                      @endif

                                    <div class="overlay-style-one bg2"></div>
                                </div>
                                <div class="date-box">
                                    <div class="left">{{ \Carbon\Carbon::parse($event->date_d)->format('d')}}</div>
                                    <div class="right">
                                        <h6>{{ \Carbon\Carbon::parse($event->date_d)->format('M')}} </h6>
                                        <h3>{{ \Carbon\Carbon::parse($event->date_d)->format('Y')}}</h3>
                                    </div>
                                </div>
                            </div> 
                            <div class="title-holder">
                                <div class="inner">
                                    <span>{{$event->location}}</span>
                                    <h3><a href="{{route('eventsSingle',[$event->id,$event->slug])}}">{{getTranslationEvent($event->id)['title']}}</a><i class="fa fa-angle-double-right" aria-hidden="true"></i></h3>
                                </div>
                                <div class="bottom">
                                    <div class="text">
                                        {{ \Carbon\Carbon::parse($event->date_d)->format('M')}}
                                        {{ \Carbon\Carbon::parse($event->date_d)->format('d')}}, 
                                        {{ \Carbon\Carbon::parse($event->date_d)->format('Y')}} -
                                        {{ \Carbon\Carbon::parse($event->date_f)->format('M')}} 
                                        {{ \Carbon\Carbon::parse($event->date_f)->format('d')}}, 
                                        {{ \Carbon\Carbon::parse($event->date_f)->format('Y')}}</div>
                                    <div class="button">
                                        <a href="{{route('eventsSingle',[$event->id,$event->slug])}}">Find More</a>
                                    </div>
                                </div>    
                            </div>   
                          </div>
                      </div>
                     @endforeach 


                  </div>
              </div>
            </div>
        </div>

        <div class="row p-top-40">
            <div class="col-xl-12">
                <ul class="styled-pagination text-center">
                    {{$events->links()}}
                </ul>
            </div>
        </div>

    </div>

    </section>





@endsection

@section('scripts')

@endsection
