@extends('frontend.layouts.app')

@section('metatags')
<meta name="description" content="Unique Packing is a fruit export company, Who is deeply committed to provid fresh produce that contain higher nutritional values." />
<meta name="keywords" content="Unique, Packing, Fruit,export, Avocados, morocco" />
<meta name="copyright" content="Yacine Boughalem">
<meta name="url" content="http://uniqpacking.ma/products">
<meta name="identifier-URL" content="http://uniqpacking.ma/products">

<meta itemprop="image" content="/assets/images/metalogo.png" />
<meta property="og:image" itemprop="image/*" content="/assets/images/metalogo.png" />
<meta property="og:image:width" content="256" />
<meta property="og:image:height" content="256" />
<meta property="og:site_name" content="Unique Packing" />
@endsection
@section('title', 'Our Products')

@section('content')

  <div class="uniq--breadcrumb--area" style="background-image: linear-gradient(to right,rgba(27, 38, 105, 0.8),rgba(58, 182, 74, .4)),url('/assets/images/banner002.jpg'); ">
        <div class="container">
            <div class="uniq--breadcrumb--area--content  wow animated bounceInLeft" data-wow-duration="1.5s" data-wow-delay=".1s">
                <h1 class="p-top-10">Our Products</h1>
            </div>
        </div>
        <img src="/assets/images/logo--shape.svg" class="shape--logo--01 wow animated bounceInRight" data-wow-duration="1.5s" data-wow-delay=".1s" />
  </div>

  <section class="uniq--products--area  section--60">
    <div class="container">
        <div class="row align-items-center ">
          @foreach($products as $key => $product)
            <div class="col-md-6">
                <a href="{{route('singleProduct',[$product->id,$product->slug])}}">
                    <div class="uniq--products--area--item image--two  wow animated bounceInUp" data-wow-duration="1.5s" data-wow-delay=".1s">
                      @if(Storage::disk('public')->exists('products/'.$product->image))
                        <img src="/storage/products/{{$product->image}}" id="profile-imgsrc">
                      @else
                        <img src="/notfound.png" id="profile-imgsrc" class="img-responsive">
                      @endif  
                        <div class="uniq--products--area--item--overlay">
                            <h2>{{getTranslationProduct($product->id)['title']}}</h2>
                        </div>
                    </div>
                </a>
            </div>
          @endforeach  
        </div>
    </div>
  </section>

@include('frontend/partials/subscribe')



@endsection

@section('scripts')
@endsection
