@extends('frontend.layouts.app')

@section('title', 'Families Help')

@section('content')


<section class="breadcrumb-area" style="background-image: 
linear-gradient(to right bottom, rgba(113, 5, 36, 0.87), rgba(28, 114, 81, 0.78)), url({{asset('frontend/images/breadcrumb/cover02.jpg')}});">  <div class="container">
      <div class="row">
          <div class="col-xl-12">
              <div class="inner-content clearfix">
                  <div class="title">
                     <h1>{{getTranslationPost($post->id)['title']}}</h1>
                  </div>
                  <div class="breadcrumb-menu">
                      <ul class="clearfix">
                          <li><a href="index-2.html">Accueil</a></li>
                          <li class="active">{{getTranslationPost($post->id)['title']}}</li>
                      </ul>    
                  </div>
              </div>
          </div>
      </div>
  </div>
</section>



<section class="blog-single-area">
  <div class="container">
      <div class="row">
          <div class="col-xl-8 col-lg-8 col-md-12 col-sm-12">
              <div class="blog-post">
                  <div class="blog-details-content">
                      <div class="recent-post">
                        <div class="recent-post-carousel owl-carousel owl-theme owl-nav-style-one">
                            <div class="single-recent-post">
                                <div class="img-holder">
                                    <img src="{{asset('storage/posts/'.$post->image)}}" alt="Awesome Image">
                                </div>
                            </div>
                        </div> 
                      </div>
                      {{-- <div class="img-holder">
                          <img src="http://geoparc-mgoun.ma/admin-mgoun/uploads/blog/8810355_4.jpg" alt="Awesome Image">
                      </div> --}}
                      <div class="text-holder">
                          <ul class="meta-info">
                              <li><a href="#">{{$post->created_at->format('d-m-Y')}}</a></li>
                          </ul>
                          <h2 class="blog-title">{{getTranslationPost($post->id)['title']}}</h2>
                          <div class="bottom-text-box">
                            <p>{!! getTranslationPost($post->id)['description'] !!}</p>
                        </div>
                      </div>
                     
                  </div>
                
              </div>
          </div>
          
          <!--Start sidebar Wrapper-->
          <div class="col-xl-4 col-lg-4 col-md-9 col-sm-12">
              <div class="sidebar-wrapper">
                  <div class="single-sidebar">
                      <div class="title">
                          <h3>Categories</h3>
                      </div>
                      <ul class="categories clearfix">
                        @foreach($categoriesPost as $cat_post)
                          <li>
                            <a href="{{route('CategorieBlog',[$cat_post->id,$cat_post->slug])}}" title="{{$cat_post->posts->count()}}">
                                {{getTranslationCategoriePost($cat_post->id)['name']}} - ({{$cat_post->posts->count()}})
                            </a>
                          </li>
                         
                          @endforeach
                      </ul>
                  </div>


                  <div class="single-sidebar">
                    <div class="title">
                        <h3>Tags</h3>
                    </div>
                    <ul class="categories clearfix">
                        @foreach($tags as $tag)
                        <li>
                            <a href="{{route('TagBlog',[$tag->id,$tag->slug])}}" title="{{$tag->posts->count()}}">{{ getTranslationTag($tag->id)['name']}}</a>
                        </li>
                        @endforeach
                    </ul>
                </div>

                  
                  
                  <div class="single-sidebar">
                      <div class="title">
                          <h3>Recent Posts</h3>
                      </div>
                      <div class="recent-post">
                          <div class="recent-post-carousel owl-carousel owl-theme owl-nav-style-one">
                            @foreach($postss  as $post)
                              <div class="single-recent-post">
                                  <div class="img-holder">
                                      <img src="{{asset('storage/posts/'.$post->image)}}" alt="Awesome Image">
                                      <div class="overlay-style-one bg1"></div>
                                  </div>
                                  <div class="title-holder text-center">
                                      <p>{{$post->created_at->format('d-m-Y')}}</p>
                                      <h3><a href="{{route('showBlog',[$post->id,$post->slug])}}">{{getTranslationPost($post->id)['title']}}</a></h3>
                                  </div>    
                              </div>
                            @endforeach
                            
                          </div> 
                      </div>
                  </div>
       
              </div>    
          </div>
          
      </div>
      <div class="row">
        <div class="col-xl-12">
            <div class="project-single-prev-next-button wow slideInUp" data-wow-delay="00ms" data-wow-duration="1500ms">
                <div class="button">
                    <a class="prev" href="{{route('PrevPost',[$post->id,$post->slug])}}"><i class="fa fa-angle-double-left" aria-hidden="true"></i>Prev Post</a>
                    <a class="middle" href="/blog">
                        <img src="{{asset('frontend/images/icon/prev-next-button-icon.png')}}" alt="Button Icon">
                    </a>
                    <a class="next" href="{{route('NextPost',[$post->id,$post->slug])}}">Next Post<i class="fa fa-angle-double-right" aria-hidden="true"></i></a>
                </div>    
            </div>
        </div>
    </div>
  </div>
</section> 


@endsection

@section('scripts')

@endsection
