@extends('backend.layouts.app')

@section('title', 'Show Attributs')


@push('styles')

    <link rel="stylesheet" href="{{ asset('backend/plugins/bootstrap-select/css/bootstrap-select.css') }}">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-fileinput/4.4.5/css/fileinput.min.css" media="all"
        rel="stylesheet" type="text/css" />
    <!-- Bootstrap Tagsinput Css -->
    <link href="{{ asset('backend/plugins/bootstrap-tagsinput/bootstrap-tagsinput.css') }}" rel="stylesheet">

@endpush


@section('content')





    <div class="block-header">
        <ol class="breadcrumb breadcrumb-col-pink">
            <li><a href="/admin"><i class="material-icons">home</i> Home</a></li>
            <li><a href="{{ route('admin.product.index') }}" class="active"><i
                        class="material-icons">library_books</i> Rows </a></li>
            <li><i class="material-icons">remove_red_eye</i> Row : {{ $product->title }}</li>
        </ol>
    </div>

    <div class="row"><br>
        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
            <div class="card">

                <div class="header">
                    <h2><strong style="color:black"> Geosite # {{ $product->title }}</strong></h2>
                </div>


                <div class="body">
                    <!-- Nav tabs -->
                    <ul class="nav nav-tabs tab-nav-right" role="tablist">
                        <li role="Details" class="active"><a href="#Details" data-toggle="tab">Details</a></li>
                        <li role="addAttribs"><a href="#addAttribs" data-toggle="tab">Add New Row</a></li>
                    </ul>

                    <!-- Tab panes -->
                    <div class="tab-content" id="printcontent">

                        <!-- -------------------------------------Details----------------------------------------------- -->

                        <div role="tabpanel" class="tab-pane fade in active" id="Details">
                            <div class="row clearfix">
                                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                    <h2 class="page-header">
                                        @if (Storage::disk('public')->exists('products/' . $product->image))
                                            <img src="{{ asset('storage/products/' . $product->image) }}"
                                                alt="{{ $product->title }}" class="img-responsive img-rounded"
                                                style="max-height:200px">
                                        @endif
                                    </h2>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                    <h3>
                                        ID : #{{ $product->id }}<br><br>
                                        Status:
                                        <a type="button" href="{{ url('admin/geosites/enable/' . $product->id) }}">
                                            <span
                                                class="label label-{{ $product->status == true ? 'success' : 'danger' }}">
                                                {{ $product->status == true ? 'ON' : 'OFF' }}</span></a><br><br>
                                    </h3>
                                </div>
                            </div>


                            <!-- ------------------- -->

                            <div class="row clearfix">
                                <div class="col-md-12 invoice-col">
                                    <table width="100%" class="table table-bordered">
                                        {{-- <tr style="background-color:#006100;color:#fff">
                                            <th colspan="5" class="text-center">Rows</th>
                                        </tr> --}}
                                        <tr style="background-color:#080f30;color:rgb(255, 255, 255)">
                                            <th>Images</th>
                                            <th>Description</th>
                                            <th>Action</th>
                                        </tr>
                                        @foreach ($attribs as $att)
                                            <tr>



                                                <?php $image = explode('|', $att->images); ?>
                                                <td>
                                                    @if (Storage::disk('public')->exists('attribs/' . $image[0]))
                                                        <img src="{{ asset('storage/attribs/' . $image[0]) }}"
                                                            class="img-responsive img-rounded"
                                                            style="height:50px;width:50px">
                                                    @endif
                                                </td>

                                                <td>{!! $att->description !!}</td>

                                                <td class="text-center">

                                                    <a href="{{ route('admin.attrib.edit', $att->id) }}"
                                                        class="btn btn-info btn-sm waves-effect">
                                                        <i class="material-icons">edit</i>
                                                    </a>
                                                    <button type="button" class="btn btn-danger btn-sm waves-effect"
                                                        onclick="deleteattrib({{ $att->id }})">
                                                        <i class="material-icons">delete</i>
                                                    </button>

                                                    <form action="{{ route('admin.attrib.destroy', $att->id) }}"
                                                        method="POST" id="del-attrib-{{ $att->id }}"
                                                        style="display:none;">
                                                        @csrf
                                                        @method('DELETE')
                                                    </form>

                                                </td>
                                            </tr>
                                        @endforeach
                                    </table>
                                </div><!-- /.col -->

                            </div>



                        </div>


                        <!-- -------------------------------------addAttribs----------------------------------------------- -->













                        <div role="tabpanel" class="tab-pane fade in" id="addAttribs">
                            <div class="row clearfix">
                                <div class="col-md-12 body table-responsive">

                                    <form action="{{ route('admin.attrib.store') }}" method="POST"
                                        enctype="multipart/form-data" id="form_validation" novalidate="novalidate">
                                        @csrf

                                        <div class="row clearfix">
                                            <!-- Style -->
                                            <div class="col-md-12" hidden="true">
                                                <input type="text" name="product_id" value="{{ $product->id }}">
                                            </div>

                                            <div class="col-md-12">
                                                <label class="col-form-label"> <strong style="color:black"> Title </strong>
                                                    :</label>
                                                <div class="input-group">
                                                    <div class="form-line">
                                                        <input type="text" name="title" class="form-control text"
                                                            placeholder="Title ...">
                                                    </div>
                                                </div>
                                            </div>


                                            <!-- images -->
                                            <div class="col-md-12">
                                                <div class="card" id="div_gallery">
                                                    <div class="header">
                                                        <h2>Galerie images </h2>
                                                    </div>
                                                    <div class="body">
                                                        <input id="input-id" type="file" name="images[]"
                                                            class="file" data-preview-file-type="text" multiple
                                                            accept="image/*" style="height:30%">
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- Description -->
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label for="tinymce">Description </label>
                                                    <textarea name="description" id="tinymce"></textarea>
                                                </div>
                                            </div>
                                            <!--End Description -->

                                            <button type="submit"
                                                class="btn btn-primary btn-block  btn-lg m-t-15 waves-effect">
                                                <i class="material-icons">save</i>
                                                <span>SAVE</span>
                                            </button>

                                        </div>
                                    </form>
                                </div>
                            </div><!-- end body -->
                        </div>




                        <!-- -------------------------------------END addAttribs----------------------------------------------- -->





                    </div>
                    <!-- #END# Example Tab -->

                @endsection


                @push('scripts')

                    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-fileinput/4.4.5/js/fileinput.min.js"></script>
                    <script src="{{ asset('backend/plugins/bootstrap-select/js/bootstrap-select.js') }}"></script>
                    <script src="{{ asset('backend/plugins/tinymce/tinymce.js') }}"></script>

                    <!-- Bootstrap Tags Input Plugin Js -->
                    <script src="{{ asset('backend/plugins/bootstrap-tagsinput/bootstrap-tagsinput.js') }}"></script>
                    <!-- validation -->
                    <script src="{{ asset('backend/plugins/jquery-validation/jquery.validate.js') }}"></script>
                    <!-- Custom Js -->
                    <script src="{{ asset('backend/js/pages/forms/form-validation.js') }}"></script>



                    <script>
                        $(function() {
                            $("#input-id").fileinput();
                        });

                        $(function() {
                            tinymce.init({
                                selector: "textarea#tinymce",
                                theme: "modern",
                                height: 300,
                                plugins: [
                                    'advlist autolink lists link image charmap print preview hr anchor pagebreak',
                                    'searchreplace wordcount visualblocks visualchars code fullscreen',
                                    'insertdatetime media nonbreaking save table contextmenu directionality',
                                    'emoticons template paste textcolor colorpicker textpattern imagetools'
                                ],
                                toolbar1: 'insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image',
                                toolbar2: 'print preview media | forecolor backcolor emoticons',
                                image_advtab: true
                            });
                            tinymce.suffix = ".min";
                            tinyMCE.baseURL = '{{ asset('backend/plugins/tinymce') }}';
                        });


                        function deleteattrib(id) {

                            swal({
                                title: 'Are you sure?',
                                text: "You won't be able to revert this!",
                                type: 'warning',
                                showCancelButton: true,
                                confirmButtonColor: '#3085d6',
                                cancelButtonColor: '#d33',
                                confirmButtonText: 'Yes, delete it!'
                            }).then((result) => {
                                if (result.value) {
                                    document.getElementById('del-attrib-' + id).submit();
                                    swal(
                                        'Deleted!',
                                        'attrib has been deleted.',
                                        'success'
                                    )
                                }
                            })
                        }
                    </script>


                @endpush
