@extends('backend.layouts.app')

@section('title', 'Edit Categories')

@push('styles')

    
@endpush


@section('content')

  <div class="block-header">
        <ol class="breadcrumb breadcrumb-col-pink">
                                <li><a href="/admin"><i class="material-icons">home</i> Home</a></li>
                                <li><a href="{{route('admin.tag.index')}}"><i class="material-icons">label</i> Tags </a></li>
                                <li class="active"><i class="material-icons">mode_edit</i>Edit Tag</li>
                            </ol>
    </div>


    <div class="row clearfix">
        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
            <div class="card">
                <div class="header">
                    <h2>EDIT CATEGORY</h2>
                </div>
                <div class="body">
                    <form action="{{route('admin.categoriePost.update',$category->id)}}" method="POST" enctype="multipart/form-data" id="form_validation"  novalidate="novalidate">
                        @csrf
                        @method('PUT')

                        <div class="form-group form-float">
                            <div class="form-line">
                                <input type="text" name="name" class="form-control" value="{{$category->name}}" required="">
                                <label class="form-label">Category</label>
                            </div>
                        </div>


                    <div class="row clearfix">
                  <div class="col-sm-6">
           <label class="col-form-label"> <strong style="color:black"> Image  </strong> <span style="color:red">*</span> :</label>               
                        <div class="form-group form-float">
                            <input type="file" name="image" id="profile-image-input" style="display:none;" required="">
                            <button type="button" class="btn bg-white btn-sm waves-effect m-t-15" id="profile-image-btn">
                                <i class="material-icons" style="color:black">image</i>
                                <span style="color:black">UPLOAD IMAGE</span>
                            </button><br><br>
                            <img src="{{asset('storage/categoriePost/'.$category->image)}}" id="profile-imgsrc" class="img-responsive" style="width:130px;height:130px;">
                       </div>
                   </div>
               </div>
               

                      <button type="submit" class="btn btn-primary btn-block m-t-15 waves-effect"><i class="material-icons">edit </i> Modifier</button>
                      
                    </form>
                </div>
            </div>
        </div>
    </div>

@endsection


@push('scripts')
      <!-- validation -->
      <script src="{{ asset('backend/plugins/jquery-validation/jquery.validate.js')}}"></script>
        <!-- Custom Js -->
       <script src="{{ asset('backend/js/pages/forms/form-validation.js')}}"></script>


<script>
    $(function(){
        function showImage(fileInput,imgID){
            if (fileInput.files[0]) {
                var reader = new FileReader();
                reader.onload = function(e){
                    $(imgID).attr('src',e.target.result);
                    $(imgID).attr('alt',fileInput.files[0].name);
                }
                reader.readAsDataURL(fileInput.files[0]);
            }
        }
        $('#profile-image-btn').on('click', function(){
            $('#profile-image-input').click();
        });
        $('#profile-image-input').on('change', function(){
            showImage(this, '#profile-imgsrc');
    
    var img = document.getElementById('profile-imgsrc');
    img.style.display = 'block';

        });
    })
</script>

@endpush
