@extends('frontend.layouts.app')

@section('title', 'Families Help')

@section('content')

<section class="breadcrumb-area" style="background-image: 
linear-gradient(to right bottom, rgba(113, 5, 36, 0.87), rgba(28, 114, 81, 0.78)), url({{asset('frontend/images/breadcrumb/cover02.jpg')}});">  <div class="container">
      <div class="row">
          <div class="col-xl-12">
              <div class="inner-content clearfix">
                  <div class="title">
                     <h1>{{getTranslationGalerie($galerie->id)['titre']}}</h1>
                  </div>
                  <div class="breadcrumb-menu">
                      <ul class="clearfix">
                          <li><a href="/">Accueil</a></li>
                          <li class="active">{{getTranslationGalerie($galerie->id)['titre']}}</li>
                      </ul>    
                  </div>
              </div>
          </div>
      </div>
  </div>
</section>


<section class="about-style01-area">
  <div class="container">
      <div class="row justify-content-center">
          <div class="col-xl-10 col-lg-12 text-center">
              <div class="about-style1-content section-header">
                <div class="section-title-border">
									<span>M'GOUN EN PHOTOS</span>
                  <h1>{{getTranslationGalerie($galerie->id)['titre']}}</h1>
								</div>
                  
                  <div class="inner-content">
                      <div class="text">
                        {!! getTranslationGalerie($galerie->id)['description'] !!}
                      </div>
                  </div>    
              </div>   
          </div>
          
      </div> 
  </div>    
</section>



<section class="gallery-area"  style=" background: url({{asset('frontend/images/pattern/pattern-bg1.png')}}) #fbfffe;background-repeat: repeat;">
  <div class="container">
      <div class="sortable-masonry">
         
          <div class="row items-container clearfix">
            <?php   $imagess=explode('|',$galerie->images); ?>
          
            @for($i=0; $i <@count($imagess)-1; $i++)
              <div class="col-xl-4 col-lg-6 col-md-6 col-sm-12 masonry-item all art insta">
                  <div class="single-art-box-style2 marbtm50">
                      <div class="img-holder">
                          <img src="{{asset('storage/galeries/'.$imagess[$i])}}" alt="Awesome Image">
                          <div class="overlay-content">
                              <div class="zoom-button">
                                  <a class="lightbox-image" data-fancybox="gallery" href="{{asset('storage/galeries/'.$imagess[$i])}}">
                                      <i class="fa fa-search-plus" aria-hidden="true"></i>
                                  </a>
                              </div>
                          </div>
                      </div>
                  </div>
              </div>
              @endfor
          </div>
      </div>
  </div>
</section>



<section class="about-style01-area">
    <div class="container-fluid">
        <div class="row justify-content-center">
            <div class="col-xl-10 col-lg-12 text-center">
                <div class="about-style1-content section-header">
                  <div class="section-title-border">
                        <span>M'GOUN </span>
                        <h1>EN PHOTOS</h1>
                    </div>
                </div>   
            </div>
        </div> 
        <div class="row align-items-center justify-content-center">
        <div class="gal0ne owl-carousel owl-theme owl-nav-style-one">
          @foreach($galeriee as $galerie)
          <div class="item">
            <a href="{{route('ShowGal',[$galerie->id,$galerie->slug])}}">
            <div class="box_our_values">
              <div class="box_our_values_icon">
                <svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                width="30.38" height="36.82" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve">
                <g>
                  <g>
                    <path style="fill:#337351;" d="M494.933,38.4h-409.6c-9.412,0-17.067,7.654-17.067,17.067v17.067H51.2c-9.412,0-17.067,7.654-17.067,17.067v17.067
                    H17.067C7.654,106.667,0,114.321,0,123.733v332.8c0,9.412,7.654,17.067,17.067,17.067h409.6c9.412,0,17.067-7.654,17.067-17.067
                    v-17.067H460.8c9.412,0,17.067-7.654,17.067-17.067v-17.067h17.067c9.412,0,17.067-7.654,17.067-17.067v-332.8
                    C512,46.054,504.346,38.4,494.933,38.4z M17.067,123.733h409.6l0.009,190.635l-44.783-51.183c-3.251-3.721-9.6-3.721-12.851,0
                    l-54.067,61.79L167.799,194.159c-3.234-2.884-8.098-2.884-11.332,0L17.067,318.071V123.733z M426.684,431.01v25.523H17.067V340.89
                    l145.067-128.947l147.934,131.49c1.69,1.51,3.942,2.193,6.204,2.142c2.278-0.145,4.395-1.186,5.888-2.901l53.308-60.911
                    l51.209,58.53l0.008,90.573c0,0.017-0.017,0.043-0.017,0.068S426.684,430.985,426.684,431.01z M460.8,422.4h-17.067V123.733
                    c0-9.412-7.654-17.067-17.067-17.067H51.2V89.6h409.6V422.4z M494.933,388.267h-17.067V89.6c0-9.412-7.654-17.067-17.067-17.067
                    H85.333V55.467h409.6V388.267z"/>
                  </g>
                </g>
                <g>
                  <g>
                    <path style="fill:#337351;" d="M307.2,174.933c-18.825,0-34.133,15.309-34.133,34.133S288.375,243.2,307.2,243.2s34.133-15.309,34.133-34.133
                    S326.025,174.933,307.2,174.933z M307.2,226.133c-9.412,0-17.067-7.654-17.067-17.067c0-9.412,7.654-17.067,17.067-17.067
                    s17.067,7.654,17.067,17.067C324.267,218.479,316.612,226.133,307.2,226.133z"/>
                  </g>
                </g>
              </svg>
              </div>
              <div class="box_our_values_content">
                <h4>{{getTranslationGalerie($galerie->id)['titre']}}</h4>
              </div>
            </div>
            </a>
          </div>
          @endforeach
         
     
        </div>    
    </div>    
    </div>    
  </section>


@endsection

@section('scripts')

@endsection
