@extends('frontend.layouts.app')

@section('metatags')
<meta name="description" content="Unique packing exports premium avocados from the north of the Moroccan kingdom to its clients around the globe." />
<meta name="keywords" content="Unique, Packing, Fruit,export, Avocados, morocco" />
<meta name="copyright" content="Yacine Boughalem">
<meta name="url" content="http://uniqpacking.ma/about-us">
<meta name="identifier-URL" content="http://uniqpacking.ma/about-us">

<meta itemprop="image" content="https://www.uniqpacking.ma/assets/images/logo-uniq.jpg" />
<meta property="og:image" itemprop="image/*" content="https://www.uniqpacking.ma/assets/images/logo-uniq.jpg" />
<meta property="og:image:width" content="256" />
<meta property="og:image:height" content="256" />
<meta property="og:site_name" content="Unique Packing" />
<link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">

@endsection
@section('title', 'About us')

@section('content')

<div class="uniq--breadcrumb--area" style="background-image: linear-gradient(to right,
rgba(27, 38, 105, 0.8),rgba(58, 182, 74, .4)),url('./assets/images/banner001.jpg');">
        <div class="container">
            <div class="uniq--breadcrumb--area--content">
                <h1 class="p-top-10 wow animated bounceInLeft" data-wow-duration="1.5s" data-wow-delay=".1s">
                    @lang('uniqpacking.ABOUT_US')
                </h1>
            </div>
        </div>
        <img src="./assets/images/logo--shape.svg" class="shape--logo--01 wow animated bounceInRight" data-wow-duration="1.5s" data-wow-delay=".1s" />
    </div>

    <section class="uniq--about--area p-top-40 p-bottom-40">
      <div class="container">
          <div class="row align-items-center">
              <div class="col-md-6">
                  <div class="primary--title  wow animated bounceInLeft" data-wow-duration="1.5s" data-wow-delay=".1s">
                      <h2>@lang('uniqpacking.ABOUT_US')</h2>
                  </div>
                  <div class="second--title p-top-20">
                      <h3 class="second--title--h3  wow animated fadeInLeft" data-wow-duration="1.5s" data-wow-delay=".1s">
                        @lang('uniqpacking.ABOUT2_TITLE')
                      </h3>
                  </div>
                  <div class="t--paragraph--one p-top-10 wow animated fadeInLeft" data-wow-duration="1.5s" data-wow-delay=".1s">
                    @lang('uniqpacking.ABOUT2_DESC') 
                  </div>


              </div>
              <div class="col-md-6">
                  <div class="image--three  wow animated fadeInRight" data-wow-duration="1.5s" data-wow-delay=".1s">
                      <img src="./assets/images/uniq--about--01.jpg" alt="" />
                  </div>
              </div>
          </div>
      </div>
  </section>

  <section class="uniq--about3--area section--60">
      <div class="container">
          <div class="row justify-content-center align-items-center">
              <div class="col-md-8">
                  <div class="primary--title--center--white p-bottom-60  wow animated fadeInUp" data-wow-duration="1.5s" data-wow-delay=".1s">
                      <h2>
                        @lang('uniqpacking.ABOUT3_TITLE') 
                      </h2>
                  </div>

                  <div class="uniq--about3--area--text p-bottom-20 wow animated fadeInUp" data-wow-duration="1.5s" data-wow-delay=".1s">
                      <p>
                        @lang('uniqpacking.ABOUT3_DESC') 
                      </p>
                  </div>
                  <div class="uniq--about3--area--video  wow animated fadeInUp" data-wow-duration="1.5s" data-wow-delay=".1s">
                      <button type="button" class="video-btn uniq--about3--area--video--btn" data-bs-toggle="modal" data-src="https://player.vimeo.com/video/58385453?badge=0" data-bs-target="#myModal">
            <svg id="play-button" xmlns="http://www.w3.org/2000/svg" width="61.361" height="61.361"
              viewBox="0 0 61.361 61.361">
              <path id="Path_65" data-name="Path 65"
                d="M11.235,6.722A1.461,1.461,0,0,0,9,7.961V37.18a1.461,1.461,0,0,0,2.235,1.239L34.611,23.81a1.461,1.461,0,0,0,0-2.478ZM31.08,22.571,11.922,34.544V10.6Z"
                transform="translate(12.915 8.11)" fill="#39b54a" fill-rule="evenodd" />
              <path id="Path_66" data-name="Path 66"
                d="M32.18,1.5a30.68,30.68,0,1,0,30.68,30.68A30.68,30.68,0,0,0,32.18,1.5ZM4.422,32.18A27.758,27.758,0,1,1,32.18,59.939,27.758,27.758,0,0,1,4.422,32.18Z"
                transform="translate(-1.5 -1.5)" fill="#39b54a" fill-rule="evenodd" />
            </svg>
          </button>
                  </div>
              </div>

          </div>
      </div>
  </section>

  <section class="uniq--brand--area section--80">
      <div class="container">
          <div class="row justify-content-center align-items-center">
              <div class="col-md-4">
                  <div class="uniq--brand--area--logo p-bottom-30 image--two  wow animated fadeInLeft" data-wow-duration="1.5s" data-wow-delay=".1s">
                      <img src="./assets/images/uniq--produce.svg" class="img-responsive" />
                  </div>

              </div>
              <div class="col-md-12">
                  <div class="uniq--brand--area--values">
                      <div class="uniq--brand--area--values--item wow animated fadeInUp" data-wow-duration="1.5s" data-wow-delay=".1s">
                          <div class="uniq--brand--area--values--item--head">
                              <img src="./assets/images/uniq--prod--01.png" alt="">
                          </div>
                          <div class="uniq--brand--area--values--item--content">
                              <h3>@lang('uniqpacking.ABOUT_BRAND_TITLE_1') </h3>
                              <p>
                                @lang('uniqpacking.ABOUT_BRAND_DESC_1') 
                              </p>
                          </div>
                      </div>
                      <div class="uniq--brand--area--values--item wow animated fadeInUp" data-wow-duration="1.5s" data-wow-delay=".1s">
                          <div class="uniq--brand--area--values--item--head">
                              <img src="./assets/images/uniq--prod--02.png" alt="">
                          </div>
                          <div class="uniq--brand--area--values--item--content">
                              <h3>
                                  @lang('uniqpacking.ABOUT_BRAND_TITLE_2')
                                </h3>
                              <p>
                                @lang('uniqpacking.ABOUT_BRAND_DESC_2') 
                              </p>
                          </div>
                      </div>
                      <div class="uniq--brand--area--values--item wow animated fadeInUp" data-wow-duration="1.5s" data-wow-delay=".1s">
                          <div class="uniq--brand--area--values--item--head">
                              <img src="./assets/images/uniq--prod--03.png" alt="">
                          </div>
                          <div class="uniq--brand--area--values--item--content">
                              <h3>
                                @lang('uniqpacking.ABOUT_BRAND_TITLE_3')
                              </h3>
                              <p>
                                @lang('uniqpacking.ABOUT_BRAND_DESC_3')                               </p>
                          </div>
                      </div>

                  </div>
              </div>

          </div>
      </div>
  </section>

  <section class="uniq--form--area section--40 bg--02">
      <div class="container">
          <div class="row align-items-center">
              <div class="col-md-12">
                  <div class="primary--title--center--prim wow animated fadeInUp" data-wow-duration="1.5s" data-wow-delay=".1s">
                      <h2>@lang('uniqpacking.FORM_TITLE_1')
                      </h2>
                  </div>
                  <div class="t--paragraph--one text-center p-top-20 wow animated fadeInUp" data-wow-duration="1.5s" data-wow-delay=".1s">
                    @lang('uniqpacking.FORM_DESC_1')
                  </div>
              </div>
          </div>
          <div class="row align-items-center justify-content-center p-top-20 wow animated fadeInUp" data-wow-duration="1.5s" data-wow-delay=".1s">
              <div class="col-md-6">
                <form  action="{{ route('about.message') }}" method="post" class="form" > 
                    @csrf
                        <input type="hidden" id="type" name="type" value="ABOUT" >

                      <div class="form-group">
                          <label for="name" class="form-label form-label--required">
                            @lang('uniqpacking.NAME'):
                    </label>

                          <div class="form-addon" data-states-for="name">
                              <div class="form-addon__addon">
                                  <span class="icon-name"></span>
                              </div>

                              <input type="text" id="name" name="name" class="form-input" placeholder="@lang('uniqpacking.FULLNAME')" required>

                              <span class="form-addon__icon icon-valid"></span>
                              <span class="form-addon__icon icon-invalid"></span>
                          </div>

                         
                      <div class="form-group">
                          <label for="email" class="form-label form-label--required">
                            @lang('uniqpacking.EMAIL'):
                    </label>

                          <div class="form-addon" data-states-for="email">
                              <div class="form-addon__addon">
                                  <span class="icon-email"></span>
                              </div>

                              <input type="email" id="email" name="email" class="form-input" placeholder="@lang('uniqpacking.YOURMAIL')" required>

                              <span class="form-addon__icon icon-valid"></span>
                              <span class="form-addon__icon icon-invalid"></span>
                          </div>


                      </div>

                      <div class="form-group">
                          <label for="phone" class="form-label">
                            @lang('uniqpacking.PHONENUMBER'):
                    </label>

                          <div class="form-addon" data-states-for="phone">
                              <div class="form-addon__addon">
                                  <span class="icon-phone"></span>
                              </div>

                              <input type="text" id="phone" name="phone" class="form-input" >

                              <span class="form-addon__icon icon-valid"></span>
                              <span class="form-addon__icon icon-invalid"></span>
                          </div>

                      </div>

                      <div class="form-group">
                          <label for="subject" class="form-label form-label--required">
                            @lang('uniqpacking.SUBJECT'):
                  </label>

                          <div class="form-addon" data-states-for="subject">
                              <div class="form-addon__addon">
                                  <span class="icon-name"></span>
                              </div>

                              <input type="text" id="subject" name="sujet" class="form-input" placeholder="@lang('uniqpacking.SUBJECT')" required>

                              <span class="form-addon__icon icon-valid"></span>
                              <span class="form-addon__icon icon-invalid"></span>
                          </div>

                      </div>


                      <div class="form-footer text-center">
                          <div class="button button-5 btn-auto">
                              <div id="circle"></div>
                              <button type="submit">@lang('uniqpacking.SUBSCRIBE_NOW')</button>
                          </div>
                      </div>
                  </form>
              </div>
          </div>
      </div>
  </section>

    <div class="modal fade video--modal" id="myModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    <!-- 16:9 aspect ratio -->
                    <div class="ratio ratio-16x9">
                        <iframe class="embed-responsive-item" src="" id="video" allowscriptaccess="always" allow="autoplay"></iframe>
                    </div>
                </div>
            </div>
        </div>
    </div>

@include('frontend/partials/subscribe')

@endsection

@section('scripts')
{{-- <script src="https://gabinaureche.com/GentleForm/dist/GentleForm.js"></script> --}}
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>    
   
  
@if(Session::has('message'))

    <script>
  toastr.options = {
    toastClass: 'alert',
    iconClasses: {
        error: 'alert-error',
        info: 'alert-info',
        success: 'alert-success',
        warning: 'alert-warning'
    }
}
  		toastr.success("{{ session('message') }}");
    </script>
  @endif
@endsection