@extends('backend.layouts.app')

@section('title', 'Create Tags')

@push('styles')

    
@endpush


@section('content')

  <div class="block-header">
        <ol class="breadcrumb breadcrumb-col-pink">
                                <li><a href="/admin"><i class="material-icons">home</i> Home</a></li>
                                <li><a href="{{route('admin.tag.index')}}"><i class="material-icons">label</i> Tags </a></li>
                                <li class="active"><i class="material-icons">add</i>Add Tag</li>
                            </ol>
    </div>

    <div class="row clearfix">
        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
            <div class="card">
                <div class="header">
                    <h2>CREATE TAG</h2>
                </div>
                <div class="body">
                    <form action="{{route('admin.tag.store')}}" method="POST" id="form_validation"  novalidate="novalidate">
                        @csrf

                        <div class="form-group form-float">
                            <div class="form-line">
                                <input type="text" name="name" class="form-control" required="" value="{{old('name')}}">
                                <label class="form-label">Tag <span style="color:red">*</span></label>
                            </div>
                        </div>

                        <button type="submit" class="btn btn-indigo btn-lg m-t-15 waves-effect">
                            <i class="material-icons">save</i>
                            <span>SAVE</span>
                        </button>

                    </form>
                </div>
            </div>
        </div>
    </div>

@endsection



@push('scripts')
      <!-- validation -->
      <script src="{{ asset('backend/plugins/jquery-validation/jquery.validate.js')}}"></script>
        <!-- Custom Js -->
       <script src="{{ asset('backend/js/pages/forms/form-validation.js')}}"></script>



@endpush
