const menu = document.querySelector('.menu');
const menuSection = menu.querySelector('.menu-section');
const menuArrow = menu.querySelector('.menu-mobile-arrow');
const menuClosed = menu.querySelector('.menu-mobile-close');
const menuTrigger = document.querySelector('.menu-mobile-trigger');
const menuOverlay = document.querySelector('.overlay');
let subMenu;

menuSection.addEventListener('click', (e) => {
    if (!menu.classList.contains('active')) {
        return;
    }
    if (e.target.closest('.menu-item-has-children')) {
        const hasChildren = e.target.closest('.menu-item-has-children');
        showSubMenu(hasChildren);
    }
});

menuArrow.addEventListener('click', () => {
    hideSubMenu();
});

menuTrigger.addEventListener('click', () => {
    toggleMenu();
});

menuClosed.addEventListener('click', () => {
    toggleMenu();
});

menuOverlay.addEventListener('click', () => {
    toggleMenu();
});

// Show & Hide Toggle Menu Function
function toggleMenu() {
    menu.classList.toggle('active');
    menuOverlay.classList.toggle('active');
}

// Show the Mobile Side Menu Function
function showSubMenu(hasChildren) {
    subMenu = hasChildren.querySelector('.menu-subs');
    subMenu.classList.add('active');
    subMenu.style.animation = 'slideLeft 0.5s ease forwards';
    const menuTitle = hasChildren.querySelector('i').parentNode.childNodes[0].textContent;
    menu.querySelector('.menu-mobile-title').innerHTML = menuTitle;
    menu.querySelector('.menu-mobile-header').classList.add('active');
}

// Hide the Mobile Side Menu Function
function hideSubMenu() {
    subMenu.style.animation = 'slideRight 0.5s ease forwards';
    setTimeout(() => {
        subMenu.classList.remove('active');
    }, 300);

    menu.querySelector('.menu-mobile-title').innerHTML = '';
    menu.querySelector('.menu-mobile-header').classList.remove('active');
}

// Windows Screen Resizes Function
window.onresize = function() {
    if (this.innerWidth > 991) {
        if (menu.classList.contains('active')) {
            toggleMenu();
        }
    }
};


// ----------------- SLIDER
var myCarousel = document.querySelector('#carouselExampleCaptions')
var carousel = new bootstrap.Carousel(myCarousel, {
    interval: 5000,
    wrap: false,
    pause: false,

})
var myCarousel = document.querySelector('#products')
    // var carousel = new bootstrap.Carousel(myCarousel, {
    //     interval: 5000,
    //     wrap: false,
    //     pause: false,

// })



// VIDEOS
// Gets the video src from the data-src on each button

var $videoSrc;
$('.video-btn').click(function() {
    $videoSrc = $(this).data("src");
});
console.log($videoSrc);



// when the modal is opened autoplay it  
$('#myModal').on('shown.bs.modal', function(e) {

    // set the video src to autoplay and not to show related video. Youtube related video is like a box of chocolates... you never know what you're gonna get
    $("#video").attr('src', $videoSrc + "?autoplay=1&amp;modestbranding=1&amp;showinfo=0");
})



// stop playing the youtube video when I close the modal
$('#myModal').on('hide.bs.modal', function(e) {
    // a poor man's stop video
    $("#video").attr('src', $videoSrc);
})



// ----------- FORM
// This is a demo of GentleForm:
// https://github.com/Zhouzi/GentleForm

// const toaster = document.getElementsByClassName('toaster')[0]
// const form = document.querySelector('form')

// GentleForm(form, function(event) {
//     event.preventDefault()

//     if (this.isValid()) addToast('success', 'Yay, the form is valid!')
//     else addToast('error', 'Oops, the form is invalid.')
// })

// function addToast(type, message) {
//     const toast = document.createElement('div')

//     toast.classList.add('toast')
//     toast.classList.add('toast--' + type)
//     toast.innerHTML = message

//     toaster.appendChild(toast)

//     toast.addEventListener('transitionend', function(event) {
//         if (event.propertyName !== 'transform') return

//         if (toast.classList.contains('toast--show')) {
//             setTimeout(function() {
//                 toast.classList.remove('toast--show')
//             }, 3000)
//         } else {
//             toaster.removeChild(toast)
//         }
//     }, false)

//     setTimeout(() => toast.classList.add('toast--show'), 100)
// }



// Ca




// CAROUSEL ITEMS
// var multipleCardCarousel = document.querySelector(
//     "#carouselExampleControls"
//   );
//   if (window.matchMedia("(min-width: 768px)").matches) {
//     var carousel = new bootstrap.Carousel(multipleCardCarousel, {
//       interval: false,
//     });
//     var carouselWidth = $(".carousel-inner")[0].scrollWidth;
//     var cardWidth = $(".carousel-item").width();
//     var scrollPosition = 0;
//     $("#carouselExampleControls .carousel-control-next").on("click", function () {
//       if (scrollPosition < carouselWidth - cardWidth * 4) {
//         scrollPosition += cardWidth;
//         $("#carouselExampleControls .carousel-inner").animate(
//           { scrollLeft: scrollPosition },
//           600
//         );
//       }
//     });
//     $("#carouselExampleControls .carousel-control-prev").on("click", function () {
//       if (scrollPosition > 0) {
//         scrollPosition -= cardWidth;
//         $("#carouselExampleControls .carousel-inner").animate(
//           { scrollLeft: scrollPosition },
//           600
//         );
//       }
//     });
//   } else {
//     $(multipleCardCarousel).addClass("slide");
//   }


let items = document.querySelectorAll('.carousel .carousel-item')

items.forEach((el) => {
    const minPerSlide = 4
    let next = el.nextElementSibling
    for (var i=1; i<minPerSlide; i++) {
        if (!next) {
            // wrap carousel by using first child
        	next = items[0]
      	}
        let cloneChild = next.cloneNode(true)
        el.appendChild(cloneChild.children[0])
        next = next.nextElementSibling
    }
})



// $(document).ready(function () {
//   $(".owl-carousel-prod").owlCarousel({
//     loop:true,
//     nav:true,
//     items:2,
//     margin:10,
//     autoplay:false,
//     dots: false,
//     navText:["<i class='fa fa-chevron-left  custom--arrow '></i>","<i class='fa fa-chevron-right  custom--arrow '></i>" ],

//     responsiveClass:true,
//     responsive:{
//         0:{
//             items:1,
//             nav:true
//         },
//         600:{
//             items:1,
//             nav:false
//         },
//         1000:{
//             items:2,
//             nav:true,
//             loop:false
//         }
//     }
   
//   });
  
// });

 


  // $(document).ready(function () {
  //   $(".owl-carousel-single").owlCarousel({
  //     items: 4,
  //     nav: true,
  //     dots: false,
  //     loop: true,
  //     margin: 10,
  //     mouseDrag: true,
  //     responsiveClass: true,
  //     autoplay: true,
  //     autoplayTimeout: 3000,
  //     autoplayHoverPause: true,
  //     navText:["<i class='fa fa-chevron-left  custom--arrow '></i>","<i class='fa fa-chevron-right  custom--arrow '></i>" ],
  //     responsive: {
  //       0: {
  //         items: 1,
  //       },
  //       480: {
  //         items: 2,
  //       },
  //       767: {
  //         items: 3,
  //       },
  //       992: {
  //         items: 3,
  //       },
  //       1200: {
  //         items: 4,
  //       },
  //     },
  //   });
  // });
