<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCategoriePostTranslationsTable extends Migration
{

    public function up()
    {
        Schema::create('categorie_post_translations', function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('categorie_post_id');
            $table->string('locale')->index();

            $table->text('name')->nullable();

            $table->softDeletes();
            $table->timestamps();
            $table->foreign('categorie_post_id')->references('id')->on('categorie_posts')->onDelete('cascade');

        });
    }


    public function down()
    {
        Schema::dropIfExists('categorie_post_translations');
    }
}
