<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProductsTable extends Migration
{




    public function up()
    {
        Schema::create('products', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('admin_id')->unsigned();
            $table->string("title");
            $table->string("slug");
            $table->string('image')->nullable();
            $table->integer("style")->default(1);
            $table->boolean('status')->default(true);
            $table->timestamps();
        });
    }




    public function down()
    {
        Schema::dropIfExists('products');
    }
}
