@extends('frontend.layouts.app')

@section('metatags')
<meta name="description" content="We are committed to producing fresh and high quality produce that meet international standards and our customers’ expectations." />
<meta name="keywords" content="Unique, Packing, Fruit,export, Avocados, morocco" />
<meta name="copyright" content="Yacine Boughalem">
<meta name="url" content="http://uniqpacking.ma/logistics">
<meta name="identifier-URL" content="http://uniqpacking.ma/logistics">

<meta itemprop="image" content="https://www.uniqpacking.ma/assets/images/logo-uniq.jpg" />
<meta property="og:image" itemprop="image/*" content="https://www.uniqpacking.ma/assets/images/logo-uniq.jpg" />
<meta property="og:image:width" content="256" />
<meta property="og:image:height" content="256" />
<meta property="og:site_name" content="Unique Packing" />
<link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">

@endsection
@section('title', 'Logistics')

@section('content')

<div class="uniq--breadcrumb--area" style="background-image: linear-gradient(to right,
rgba(27, 38, 105, 0.8),rgba(58, 182, 74, .4)),url('./assets/images/banner001.jpg');">
        <div class="container">
            <div class="uniq--breadcrumb--area--content">
                <h1 class="p-top-10 wow animated bounceInLeft" data-wow-duration="1.5s" data-wow-delay=".1s">
                    @lang('uniqpacking.LOGISTICS_TITLE')

                </h1>
            </div>
        </div>
        <img src="./assets/images/logo--shape.svg" class="shape--logo--01 wow animated bounceInRight" data-wow-duration="1.5s" data-wow-delay=".1s" />
    </div>


    <section class="uniq--logistics--area p-top-40 p-bottom-40">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <div class="primary--title wow animated bounceInLeft" data-wow-duration="1.5s" data-wow-delay=".1s">
                        <h2>@lang('uniqpacking.LOGISTICS_TITLE_2')</h2>
                    </div>
                    <div class="second--title p-top-20">
                        <h3 class="second--title--h3 wow animated fadeInLeft" data-wow-duration="1.5s" data-wow-delay=".1s">
                            @lang('uniqpacking.LOGISTICS_SUBTITLE')
                        </h3>
                    </div>
                    <div class="t--paragraph--one p-top-10 wow animated fadeInLeft" data-wow-duration="1.5s" data-wow-delay=".1s">
                        @lang('uniqpacking.LOGISTICS_DESC')
                    </div>


                </div>
                <div class="col-md-6">
                    <div id="carouselExampleIndicators" class="carousel slide wow animated bounceInRight" data-wow-duration="1.5s" data-wow-delay=".1s" data-bs-ride="carousel">
                        <div class="carousel-indicators">
                            <button type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide-to="0" class="active" aria-current="true" aria-label="Slide 1"></button>
                            <button type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide-to="1" aria-label="Slide 2"></button>
                            <button type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide-to="2" aria-label="Slide 3"></button>
                            <button type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide-to="3" aria-label="Slide 4"></button>
                        </div>
                        <div class="carousel-inner">
                            <div class="carousel-item image--three active">
                                <img src="./assets/images/uniq--log--01.jpg" class="d-block w-100" alt="...">
                            </div>
                            <div class="carousel-item image--three">
                                <img src="./assets/images/uniq--log--02.jpg" class="d-block w-100" alt="...">
                            </div>
                            <div class="carousel-item image--three">
                                <img src="./assets/images/uniq--log--03.jpg" class="d-block w-100" alt="...">
                            </div>
                            <div class="carousel-item image--three">
                                <img src="./assets/images/uniq--log--04.jpg" class="d-block w-100" alt="...">
                            </div>
                        </div>
                        <button class="carousel-control-prev" type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide="prev">
                            <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                            <span class="visually-hidden">Previous</span>
                        </button>
                        <button class="carousel-control-next" type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide="next">
                            <span class="carousel-control-next-icon" aria-hidden="true"></span>
                            <span class="visually-hidden">Next</span>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </section>


    <section class="uniq--logistics2--area p-top-40 ">
        <div class="container">
            <div class="row justify-content-center align-items-center">
                <div class="col-md-12">
                    <div class="second--title text-center">
                        <h3 class="second--title--h3  wow animated bounceInLeft" data-wow-duration="1.5s" data-wow-delay=".1s">
                            @lang('uniqpacking.LOGISTICS_SUBTITLE_2')
                        </h3>
                    </div>
                </div>
                <div class="col-md-12">
                    <div class="uniq--logistics2--area--boxes ">

                        <div class="uniq--logistics2--area--boxes--item box-down two  wow animated bounceInUp" data-wow-duration="1.5s" data-wow-delay=".1s">
                            <div class="uniq--logistics2--area--boxes--item--head">
                                <img src="./assets/images/Time-Monitoring.png" alt="">
                            </div>
                            <div class="uniq--logistics2--area--boxes--item--content">
                                <h3>
                                    @lang('uniqpacking.LOGISTICS_F_TITLE_1')
                                </h3>
                                <p>
                                    @lang('uniqpacking.LOGISTICS_F_DESC_1')
                                </p>
                            </div>
                        </div>
                        <div class="uniq--logistics2--area--boxes--item  one  wow animated bounceInUp" data-wow-duration="1.5s" data-wow-delay=".1s">
                            <div class="uniq--logistics2--area--boxes--item--head">
                                <img src="./assets/images/location.png" alt="">
                            </div>
                            <div class="uniq--logistics2--area--boxes--item--content">
                                <h3>
                                    @lang('uniqpacking.LOGISTICS_F_TITLE_2')
                                </h3>
                                <p>
                                    @lang('uniqpacking.LOGISTICS_F_DESC_2')
                                </p>
                            </div>
                        </div>
                        <div class="uniq--logistics2--area--boxes--item box-down three wow animated bounceInUp" data-wow-duration="1.5s" data-wow-delay=".1s">
                            <div class="uniq--logistics2--area--boxes--item--head">
                                <img src="./assets/images/temperature.png" alt="">
                            </div>
                            <div class="uniq--logistics2--area--boxes--item--content">
                                <h3>
                                    @lang('uniqpacking.LOGISTICS_F_TITLE_2')
                                </h3>
                                <p>
                                    @lang('uniqpacking.LOGISTICS_F_DESC_2')
                                </p>
                            </div>
                        </div>
                    </div>

                    <div class="uniq--logistics2--area--values" style="display: none;">
                        <div class="uniq--logistics2--area--values--item">
                            <div class="uniq--logistics2--area--values--item--head">
                                <img src="./assets/images/location.png" alt="">
                            </div>
                            <div class="uniq--logistics2--area--values--item--content">
                                <h3>Geo Location Tracking</h3>
                                <p>
                                    We provide our customers with real-time tracking information to track their package. Each shipment is tagged with a unique identification number so that anyone who receives the package can track its location.
                                </p>
                            </div>
                        </div>
                        <div class="uniq--logistics2--area--values--item">
                            <div class="uniq--logistics2--area--values--item--head">
                                <img src="./assets/images/Time-Monitoring.png" alt="">
                            </div>
                            <div class="uniq--logistics2--area--values--item--content">
                                <h3>Transmit Time Monitoring
                                </h3>
                                <p>
                                    With this information the customer can monitor the movement of the shipment from the load till final arrival.
                                </p>
                            </div>
                        </div>
                        <div class="uniq--logistics2--area--values--item">
                            <div class="uniq--logistics2--area--values--item--head">
                                <img src="./assets/images/temperature.png" alt="">
                            </div>
                            <div class="uniq--logistics2--area--values--item--content">
                                <h3>Temperature Condition Tracking
                                </h3>
                                <p>
                                    Our customers can get live overview about their shipment's temperature condition to ensure its safety.
                                </p>
                            </div>
                        </div>

                    </div>
                </div>

            </div>
        </div>
    </section>

    <section class="uniq--form--area section--40 bg--02">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-md-12">
                    <div class="primary--title--center--prim wow animated fadeInUp" data-wow-duration="1.5s" data-wow-delay=".1s">
                        <h2>
                            @lang('uniqpacking.FORM_TITLE_2')
                        </h2>
                    </div>
                </div>
            </div>
            <div class="row align-items-center justify-content-center p-top-20 wow animated fadeInUp" data-wow-duration="1.5s" data-wow-delay=".1s">
                <div class="col-md-6">
                    <form  action="{{ route('log.message') }}" method="post" class="form" > 
                        @csrf
                            <input type="hidden" id="type" name="type" value="LOGISTICS" >
                        <div class="form-group">
                            <label for="name" class="form-label form-label--required">
                                @lang('uniqpacking.NAME')
                            </label>

                            <div class="form-addon" data-states-for="name">
                                <div class="form-addon__addon">
                                    <span class="icon-name"></span>
                                </div>

                                <input type="text" id="name" name="name" class="form-input" placeholder="Full name" required>

                                <span class="form-addon__icon icon-valid"></span>
                                <span class="form-addon__icon icon-invalid"></span>
                            </div>

                           
                        </div>

                        <div class="form-group">
                            <label for="email" class="form-label form-label--required">
                                @lang('uniqpacking.EMAIL')
                            </label>

                            <div class="form-addon" data-states-for="email">
                                <div class="form-addon__addon">
                                    <span class="icon-email"></span>
                                </div>

                                <input type="email" id="email" name="email" class="form-input" placeholder="Your Mail" required>

                                <span class="form-addon__icon icon-valid"></span>
                                <span class="form-addon__icon icon-invalid"></span>
                            </div>

                        </div>

                        <div class="form-group">
                            <label for="phone" class="form-label">
                                @lang('uniqpacking.PHONENUMBER')
                            </label>

                            <div class="form-addon" data-states-for="phone">
                                <div class="form-addon__addon">
                                    <span class="icon-phone"></span>
                                </div>

                                <input type="text" id="phone" name="phone" class="form-input" >

                                <span class="form-addon__icon icon-valid"></span>
                                <span class="form-addon__icon icon-invalid"></span>
                            </div>

                        </div>

                        <div class="form-group">
                            <label for="company" class="form-label ">
                                @lang('uniqpacking.COMPANY_NAME')
                            </label>

                            <div class="form-addon" data-states-for="company">
                                <div class="form-addon__addon">
                                    <span class="icon-name"></span>
                                </div>

                                <input type="text" id="company" name="company" class="form-input" placeholder="company" required>

                                <span class="form-addon__icon icon-valid"></span>
                                <span class="form-addon__icon icon-invalid"></span>
                            </div>

                           
                        </div>
                        <div class="form-group">
                            <label for="what" class="form-label form-label--required">
                                @lang('uniqpacking.WHATH_YOU_WANT')
                            </label>

                            <div class="form-addon" data-states-for="what">
                                <div class="form-addon__addon">
                                    {{-- <span class="icon-name"></span> --}}
                                    <i class="fa fa-user"></i>
                                </div>

                                <input type="text" id="what" name="what" class="form-input" placeholder="What you want to know? " >

                                <span class="form-addon__icon icon-valid"></span>
                                <span class="form-addon__icon icon-invalid"></span>
                            </div>

                          
                        </div>
                        <div class="form-group">
                            <label for="message" class="form-label form-label--required">
                                @lang('uniqpacking.MESSAGE')
                            </label>

                            <div class="form-addon" data-states-for="message">
                                <div class="form-addon__addon">
                                    <span class="icon-name"></span>
                                </div>

                                <textarea type="text" id="message" name="message" class="form-input" placeholder="Write your message here..." required></textarea>

                                <span class="form-addon__icon icon-valid"></span>
                                <span class="form-addon__icon icon-invalid"></span>
                            </div>

                           
                        </div>


                        <div class="form-footer text-center">
                            <div class="button button-5 btn-auto">
                                <div id="circle"></div>
                                <button type="submit">@lang('uniqpacking.SUBMIT_NOW')</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>

@include('frontend/partials/subscribe')

@endsection

@section('scripts')
{{-- <script src="https://gabinaureche.com/GentleForm/dist/GentleForm.js"></script> --}}
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>    
  
@if(Session::has('message'))
    <script>
        toastr.options = {
            toastClass: 'alert',
            iconClasses: {
                error: 'alert-error',
                info: 'alert-info',
                success: 'alert-success',
                warning: 'alert-warning'
            }
        }
  		toastr.success("{{ session('message') }}");
    </script>
  @endif
@endsection