@extends('backend.layouts.app')

@section('title', 'products')

@section('content')

    <style type="text/css">
        .cc-selector input {

            margin: 0;
            padding: 0;
            -webkit-appearance: none;
            -moz-appearance: none;
            appearance: none;
        }



        .style1 {
            background-image: url(http://geoparc-mgoun.ma/image_geoparc/1.png);
        }

        .style2 {
            background-image: url(http://geoparc-mgoun.ma/image_geoparc/2.png);
        }

        .style3 {
            background-image: url(http://geoparc-mgoun.ma/image_geoparc/3.png);
        }

        .style4 {
            background-image: url(http://geoparc-mgoun.ma/image_geoparc/4.png);
        }

        .cc-selector input:active+.drinkcard-cc {
            opacity: .9;
        }

        .cc-selector input:checked+.drinkcard-cc {
            -webkit-filter: none;
            -moz-filter: none;
            filter: none;
        }

        .drinkcard-cc {
            cursor: pointer;
            background-size: contain;
            background-repeat: no-repeat;
            display: inline-block;
            width: 100px;
            height: 70px;
            -webkit-transition: all 100ms ease-in;
            -moz-transition: all 100ms ease-in;
            transition: all 100ms ease-in;
            -webkit-filter: brightness(1.8) grayscale(1) opacity(.7);
            -moz-filter: brightness(1.8) grayscale(1) opacity(.7);
            filter: brightness(1.8) grayscale(1) opacity(.7);
        }

        .drinkcard-cc:hover {
            -webkit-filter: brightness(1.2) grayscale(.5) opacity(.9);
            -moz-filter: brightness(1.2) grayscale(.5) opacity(.9);
            filter: brightness(1.2) grayscale(.5) opacity(.9);
        }

        .img {
            -webkit-filter: brightness(1.2) grayscale(.5) opacity(.9);
            -moz-filter: brightness(1.2) grayscale(.5) opacity(.9);
            filter: brightness(1.2) grayscale(.5) opacity(.9);
        }

        /*------------------------*/
        .mrg {
            margin-left: 4px
        }

        .pointer {
            cursor: pointer;
        }

    </style>


    <div class="block-header">
        <ol class="breadcrumb breadcrumb-col-pink">
            <li><a href="/admin"><i class="material-icons">home</i> Home</a></li>
            <li class="active"><i class="material-icons">receipt</i> products</li>
        </ol>
    </div>

    <div class="row clearfix">

        <div class="col-lg-12">
        </div>

        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
            <div class="card">
                <div class="header">
                    <h2>
                        <strong style="color:black">Products List</strong>
                    </h2>

                    <ul class="header-dropdown m-r--5">
                        <li class="dropdown">
                            <a href="{{ route('admin.product.create') }}"
                                class="btn bg-indigo btn-circle waves-effect waves-circle waves-float waves-light">
                                <i class="material-icons left" style="color:#fff">add</i></a>
                        </li>
                    </ul>

                </div>
                <div class="body table-responsive">
                    <table class="table">
                        <thead>
                            <tr style="background-color:#E9FAF0">
                                <th>#</th>
                                <th width="150px">Image</th>
                                <th>Title</th>
                                <th>Status</th>
                                <th class="text-center">Action</th>

                            </tr>
                        </thead>
                        <tbody>


                            @foreach ($products as $prod)
                                <tr>
                                    <th>{{ $prod->id }}</th>

                                    <?php $image = explode('|', $prod->images); ?>
                                    <td>
                                        @if (Storage::disk('public')->exists('products/' . $prod->image))
                                            <img src="{{ asset('storage/products/' . $prod->image) }}"
                                                alt="{{ $prod->title }}" style="height:60px;width:60px"
                                                class="img-responsive img-rounded">
                                        @endif
                                    </td>
                                    <td>{{ $prod->title }}</td>

                                    <td>
                                        <a href="{{ url('admin/geosite/enable/' . $prod->id) }}"
                                            class="badge {{ $prod->status == true ? 'bg-green' : 'bg-pink ' }}">{{ $prod->status == true ? 'On' : 'Off' }}</a>
                                    </td>

                                    <td class="text-center">
                                        <a href="{{ route('admin.attrib.show', $prod->id) }}"
                                            class="btn btn-success btn-sm waves-effect"
                                            title="Add Images and descriptions For Geosite {{ $prod->title }}">
                                            <i class="material-icons">add</i>
                                        </a>

                                        <a href="{{ route('admin.product.edit', $prod->id) }}"
                                            class="btn btn-info btn-sm waves-effect"
                                            title="Edit Geosite {{ $prod->title }}">
                                            <i class="material-icons">edit</i>
                                        </a>
                                        <button type="button" class="btn btn-danger btn-sm waves-effect"
                                            onclick="deletegeosite({{ $prod->id }})"
                                            title="Delete Geosite {{ $prod->title }}">
                                            <i class="material-icons">delete</i>
                                        </button>

                                        <form action="{{ route('admin.product.destroy', $prod->id) }}" method="POST"
                                            id="del-geosite-{{ $prod->id }}" style="display:none;">
                                            @csrf
                                            @method('DELETE')
                                        </form>

                                    </td>

                                </tr>

                            @endforeach

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>



@endsection



@push('scripts')

    <script>
        function deletegeosite(id) {

            swal({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                type: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.value) {
                    document.getElementById('del-geosite-' + id).submit();
                    swal(
                        'Deleted!',
                        'geosite has been deleted.',
                        'success'
                    )
                }
            })
        }
    </script>


@endpush
