@extends('backend.layouts.app')

@section('title', 'Accounts Admins and Agents')

@push('styles')

    <!-- JQuery DataTable Css -->
    <link rel="stylesheet" href="{{ asset('backend/plugins/jquery-datatable/skin/bootstrap/css/dataTables.bootstrap.css') }}">

@endpush

@section('content')

  <div class="block-header">
        <ol class="breadcrumb breadcrumb-col-pink">
                                <li><a href="/admin"><i class="material-icons">home</i> Home</a></li>
                                <li class="active"><i class="material-icons">library_books</i> Admins / Agents LIST</li>
                            </ol>
    </div>


    <div class="row clearfix">
        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
            <div class="card">
                <div class="header bg-white">
                <h2>Admins / Agents LIST</h2>
                <ul class="header-dropdown m-r--5">
                     <li class="dropdown">
     <a href="{{route('admin.comptes.create')}}" class="btn bg-indigo btn-circle waves-effect waves-circle waves-float waves-light">
        <i class="material-icons left" style="color:#fff">add</i></a>
                      </li>
                      </ul>

                </div>
                <div class="body">
                    <div class="table-responsive">

                        <table class="table table-bordered table-striped table-hover dataTable js-exportable">
                           
                        <thead>
                        <tr style="background-color:#E9FAF0">
                        <th>#</th>
                        <th class="text-center">Is Admin</th>
                        <th>Image</th>
                        <th class="text-center">Full Name</th>
                        <th>Username</th>
                        <th>Email</th>
                        <th class="text-center">Status</th>
                        <th class="text-center">Action</th>
                        </tr>
                        </thead>
                        <tbody>
 

                     @foreach($admins as $key=>$admin)
                        <tr>
                            <th>{{$key+1}}</th>
                            <th class="text-center"><span class="badge {{$admin->is_admin?'bg-green':''}}">
                                {{$admin->is_admin ? "Admin" : "Agent"}}</span></th>
                             <td>
                            @if(Storage::disk('public')->exists('admins/'.$admin->image) && $admin->image)
                             <img src="{{asset('storage/admins/'.$admin->image)}}" alt="{{$admin->title}}" width="60" class="img-responsive img-rounded">
                            @endif
                            </td>
                            <td class="text-center"><a href="{{route('admin.comptes.edit',$admin->id)}}">{{$admin->name}}</a></td>
                            <td>{{$admin->username}}</td>
                            <td>{{$admin->email}}</td>

                            <td class="text-center">
                           <a href="{{ url('admin/compte/enable/'.$admin->id)}}">
                           <span class="badge {{$admin->status?'bg-green':'bg-red'}}">
                                {{$admin->status? 'Active':'Inactive'}}
                            </span>
                            </a>
                            </td>                 
                    
                            <td class="text-center">

                                    <div class="btn-group" role="group" aria-label="Second group">
                                      
                                      <a href="{{route('admin.comptes.edit',$admin->id)}}"class="btn btn-default waves-effect">
                                            <i class="material-icons" style="color:blue">remove_red_eye</i>
                                        </a>

                                        <button type="button" class="btn btn-default waves-effect" onclick="deleteCompte({{$admin->id}})">
                                            <i class="material-icons" style="color:red">delete</i>
                                        </button>
                                        
                                    </div>   
                                           
                                        <form action="{{route('admin.comptes.destroy',$admin->id)}}" method="POST" id="del-account-{{$admin->id}}" style="display:none;">
                                            @csrf
                                            @method('DELETE')
                                        </form>

                            </td>
                               
                            </tr>
                            @endforeach
                            
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>


@endsection



@push('scripts')

    <!-- Jquery DataTable Plugin Js -->
    <script src="{{ asset('backend/plugins/jquery-datatable/jquery.dataTables.js') }}"></script>
    <script src="{{ asset('backend/plugins/jquery-datatable/skin/bootstrap/js/dataTables.bootstrap.js') }}"></script>
    <script src="{{ asset('backend/plugins/jquery-datatable/extensions/export/dataTables.buttons.min.js') }}"></script>
    <script src="{{ asset('backend/plugins/jquery-datatable/extensions/export/buttons.flash.min.js') }}"></script>
    <script src="{{ asset('backend/plugins/jquery-datatable/extensions/export/jszip.min.js') }}"></script>
    <script src="{{ asset('backend/plugins/jquery-datatable/extensions/export/pdfmake.min.js') }}"></script>
    <script src="{{ asset('backend/plugins/jquery-datatable/extensions/export/vfs_fonts.js') }}"></script>
    <script src="{{ asset('backend/plugins/jquery-datatable/extensions/export/buttons.html5.min.js') }}"></script>
    <script src="{{ asset('backend/plugins/jquery-datatable/extensions/export/buttons.print.min.js') }}"></script>

    <!-- Custom Js -->
    <script src="{{ asset('backend/js/pages/tables/jquery-datatable.js') }}"></script>

    <script>
        function deleteCompte(id){
            
            swal({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.value) {
                    document.getElementById('del-account-'+id).submit();
                    swal(
                    'Deleted!',
                    'Account has been deleted.',
                    'success'
                    )
                }
            })
        }
    </script>


@endpush