<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAttribTranslationsTable extends Migration
{



    public function up()
    {
        Schema::create('attrib_translations', function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('attrib_id');
            $table->string('locale')->index();

            $table->string('title')->unique();
            $table->text('description')->nullable();

            $table->softDeletes();
            $table->timestamps();
            $table->foreign('attrib_id')->references('id')->on('attribs')->onDelete('cascade');
        });
    }





    public function down()
    {
        Schema::dropIfExists('attrib_translations');
    }
}
