<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBannersTranslationsTable extends Migration
{



    public function up()
    {
        Schema::create('banners_translations', function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('banner_id');
            $table->string('locale')->index();

            $table->string('title')->unique();
            $table->text('subtitle')->nullable();

            $table->softDeletes();
            $table->timestamps();
            $table->foreign('banner_id')->references('id')->on('banners')->onDelete('cascade');
        });
    }


    public function down()
    {
        Schema::dropIfExists('banners_translations');
    }
}
