<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Event;
use App\Geosite;


class EventController extends Controller
{


     public function index()
    {
        $events = Event::whereStatus(1)->orderBy('date_d', 'desc' )->paginate(8);
        


        return view('frontend.events.index',compact('events')); 

    }


   public function show($id,$slug)
    {   
    	$event=Event::findOrFail($id);
        $geosites=Geosite::whereStatus(1)->get();
        $r_events=Event::whereStatus(1)->orderBy('date_d', 'desc' )->whereNotIn('id',[$event->id])->limit(6)->get();
        $d_events=Event::whereStatus(1)->orderBy('created_at', 'desc' )->whereNotIn('id',[$event->id])->limit(6)->get();


        
        return view('frontend.events.single', compact('event','geosites','r_events','d_events'));
    }


     public function NextProduit($id){  

        $id_next = Event::where('id', '>', $id)->whereStatus(1)->min('id');

        if($id_next == null ){ $event =Event::findOrFail($id); }
        else{  $event =Event::findOrFail($id_next);  }  
            
       return redirect()->route('eventsSingle',[$event->id,$event->slug]); 
      }
              


     public function PrevProduit($id){

        $id_next = Event::where('id', '<', $id)->whereStatus(1)->max('id');

        if($id_next == null ){ $event =Event::findOrFail($id); }
        else{  $event =Event::findOrFail($id_next);  }  
            
       return redirect()->route('eventsSingle',[$event->id,$event->slug]); 
      }
          


}
