<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\Facades\Image;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Input;
use Carbon\Carbon;
use App\Video;
use Session;
use DB;
use Validator;
use Toastr;

class VideoController extends Controller
{
  

    public function index()
    {
        $videos = Video::latest()->get();

        return view('admin.videos.index', compact('videos'));
    }




    public function create()
    {
        return view('admin.videos.create');
    }



    public function store(Request $request)
    {

        $this->validate($request, [
            'titre'            => 'required|max:191',
            'link'            => 'required|max:191',
            'image'            => 'required',
        ]);


        $image = $request->file('image');
        $slug  = Str::slug($request->titre);
     //upload image
        if(isset($image)){
            $currentDate = Carbon::now()->toDateString();
            $imagename = $slug.'-'.$currentDate.'-'.uniqid().'.'.$image->getClientOriginalExtension();

            if(!Storage::disk('public')->exists('videos')){
                Storage::disk('public')->makeDirectory('videos'); }
            
             $PImage = Image::make($image->getRealPath());
             $PImage->stream();
            Storage::disk('local')->put('public/videos/'.$imagename, $PImage);
                                           }
         else{ $imagename="default.png"; }    


        $video = new Video();

        $video->img = $imagename;
        $video->title = $request->titre;
        $video->slug  = $slug;
        $video->link = $request->link;
        $video->description = $request->description;
        $video->status = $request->has('status') ? 1 : 0;
        $video->save();

        Toastr::success('message', 'video created successfully.'); 
        return redirect()->route('admin.video.index');
    }






    public function edit($id)
    {
        $video = Video::findOrFail($id);
            return view('admin.videos.edit', compact('video'));
    }



    public function update(Request $request, $id)
    {


        $this->validate($request, [
            'titre'    => ['required', 'max:191'],
            'link'     => 'required|max:191',
        ]);


           $video = Video::findOrFail($id);
           $slug  = Str::slug($request->titre);

        $image = $request->file('image');
     //upload image
        if(isset($image)){
            $currentDate = Carbon::now()->toDateString();
            $imagename = $slug.'-'.$currentDate.'-'.uniqid().'.'.$image->getClientOriginalExtension();

            if(!Storage::disk('public')->exists('videos')){
                Storage::disk('public')->makeDirectory('videos'); }

                 if (Storage::disk('public')->exists('videos/' . $video->img)) {
                Storage::disk('public')->delete('videos/' . $video->img);
            }
            
             $PImage = Image::make($image->getRealPath());
             $PImage->stream();
            Storage::disk('local')->put('public/videos/'.$imagename, $PImage);
                                           }
         else{ $imagename=$video->img; }    



        $video->img= $imagename;
        $video->title = $request->titre;
        $video->slug  = $slug;
        $video->link = $request->link;
        $video->description = $request->description;
        $video->status = $request->has('status') ? 1 : 0;
        $video->save();

        Toastr::success('message', 'video updated successfully.'); 
        return redirect()->route('admin.video.index');

    }





    public function destroy($id)
    {
        $video = Video::findOrFail($id);
          // DB::table('videos_translations')->where('video_id',$id)->delete();
        $video->delete();

        Toastr::success('message', 'videos deleted successfully.'); 
        return redirect()->route('admin.video.index');
    }



    public function enable($id) {

        $video = Video::findOrFail($id);
            if ($video->status == 1)          
            { Video::where('id', $id)->update(['status' => 0]);
            Toastr::success('message', 'élement invisible.'); }
            else
            { Video::where('id', $id)->update(['status' => 1]);
            Toastr::success('message', 'élement visible.'); }
          
          return redirect()->route('admin.video.index');
    }




}
