<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Language;


use App\Product;
use App\Attrib;
use App\Galerie;
use App\Video;
use App\CategoriePost;
use App\Tag;
use App\Post;
use App\Banner;
use App\Partner;

use App\ProductTranslations;
use App\AttribTranslations;
use App\GaleriesTranslations;
use App\VideoTranslations;
use App\CategoriePostTranslations;
use App\TagTranslations;
use App\PostTranslations;
use App\BannersTranslations;
use App\PartnerTranslations;

class TranslateController extends Controller
{
    













/*-------------------------------------Geosites--------------------------------------------------------------*/
/*Geosite*/

    public function Product()
    {
          $products = Product::latest()->get();
          $languages = Language::latest()->get();

    return view('admin.Traduction.translate.products', compact('products','languages'));
  
    }

    public function StoreProduct(Request $request)
    {
          $products = Product::latest()->get();
          $languages = Language::latest()->get();
          
          foreach ($products as $key => $ba) {
          foreach ($languages as $key => $lang) {
             //les champe de products translater
             $title = $request['title'.$ba->id.''.$lang->code];
              if ($title!=null) {
                     //test si deja products transalte with this lang

                   $old_transalte=GeositeTranslations::where('geosite_id',$ba->id)->where('locale',$lang->code)->get();
                        //si deja existe translate donc il faut update 
                         if(count($old_transalte)){
                              $old_translate_ba=GeositeTranslations::find($old_transalte[0]->id);
                              $old_translate_ba->title = $title;
                              $old_translate_ba->save();
                             } 
                             //si non il faut create new translate with this lang
                          else{   
                              $new_translate_ba = new GeositeTranslations();
                              $new_translate_ba->geosite_id=$ba->id;
                              $new_translate_ba->locale =$lang->code;
                              $new_translate_ba->title = $title;
                              $new_translate_ba->save();
                              }
                         }
          }//end for
          }//end for
       
         session()->flash('success','Traduction products successful');
         return view('admin.Traduction.translate.geosites', compact('products','languages'));
  
    }



/*Attrib*/

    public function Attrib($product_id)
    {
          $attribs = Attrib::where('product_id',$product_id)->get();
          $product = Product::findOrFail($product_id);
          $languages = Language::latest()->get();

    return view('admin.Traduction.translate.attribs', compact('attribs','languages','product'));
  
    }

    public function StoreAttrib(Request $request,$product_id)
    {
          $attribs = Attrib::where('product_id',$product_id)->get();
          $product = Product::findOrFail($product_id);
          $languages = Language::latest()->get();
          
          foreach ($attribs as $key => $ga) {
          foreach ($languages as $key => $lang) {
                     
                     //les champe de attribs translater
                    $title = $request['title'.$ga->id.''.$lang->code];
                    $description = $request['description'.$ga->id.''.$lang->code];    
          //dd($title);
              if ($title!=null) {
                     //test si deja attribs transalte with this lang

                      $old_transalte=AttribTranslations::where('attrib_id',$ga->id)->where('locale',$lang->code)->get();
                        //si deja existe translate donc il faut update 
                         if(count($old_transalte)){

                              $old_translate_ga=AttribTranslations::find($old_transalte[0]->id);
                              $old_translate_ga->title = $title;
                              $old_translate_ga->description = $description;
                              $old_translate_ga->save();
                             } 
                             //si non il faut create new translate with this lang
                          else{   
                              $new_translate_ga = new AttribTranslations();
                              $new_translate_ga->attrib_id=$ga->id;
                              $new_translate_ga->locale =$lang->code;
                              $new_translate_ga->title = $title;
                              $new_translate_ga->description = $description;
                              $new_translate_ga->save();
                              }
                         }


          }//end for
          }//end for
       session()->flash('success','Traduction attribs successful');
         return view('admin.Traduction.translate.attribs', compact('attribs','languages','product'));
  
    }








/*Banner*/

    public function Banner()
    {
          $banners = Banner::latest()->get();
          $languages = Language::latest()->get();

    return view('admin.Traduction.translate.banners', compact('banners','languages'));
  
    }

    public function StoreBanner(Request $request)
    {
          $banners = Banner::latest()->get();
          $languages = Language::latest()->get();
          
          foreach ($banners as $key => $ba) {
          foreach ($languages as $key => $lang) {
                     
                     //les champe de banners translater
                    $title = $request['title'.$ba->id.''.$lang->code];
                    $subtitle = $request['subtitle'.$ba->id.''.$lang->code];    
          //dd($title);
              if ($title!=null) {
                     //test si deja banners transalte with this lang

                      $old_transalte=BannersTranslations::where('banner_id',$ba->id)->where('locale',$lang->code)->get();
                        //si deja existe translate donc il faut update 
                         if(count($old_transalte)){

                              $old_translate_ba=BannersTranslations::find($old_transalte[0]->id);
                              $old_translate_ba->title = $title;
                              $old_translate_ba->subtitle = $subtitle;
                              $old_translate_ba->save();
                             } 
                             //si non il faut create new translate with this lang
                          else{   
                              $new_translate_ba = new BannersTranslations();
                              $new_translate_ba->banner_id=$ba->id;
                              $new_translate_ba->locale =$lang->code;
                              $new_translate_ba->title = $title;
                              $new_translate_ba->subtitle = $subtitle;
                              $new_translate_ba->save();
                              }
                         }


          }//end for
          }//end for
       session()->flash('success','Traduction Sliders successful');
         return view('admin.Traduction.translate.banners', compact('banners','languages'));
  
    }



/*Partner*/

    public function Partner()
    {
          $partners = Partner::latest()->get();
          $languages = Language::latest()->get();

    return view('admin.Traduction.translate.partners', compact('partners','languages'));
  
    }

    public function StorePartner(Request $request)
    {
          $partners = Partner::latest()->get();
          $languages = Language::latest()->get();
          
          foreach ($partners as $key => $ba) {
          foreach ($languages as $key => $lang) {
                     
                     //les champe de partners translater
                    $title = $request['title'.$ba->id.''.$lang->code];
          //dd($title);
              if ($title!=null) {
                     //test si deja partners transalte with this lang

                      $old_transalte=PartnerTranslations::where('partner_id',$ba->id)->where('locale',$lang->code)->get();
                        //si deja existe translate donc il faut update 
                         if(count($old_transalte)){

                              $old_translate_ba=PartnerTranslations::find($old_transalte[0]->id);
                              $old_translate_ba->title = $title;
                              $old_translate_ba->save();
                             } 
                             //si non il faut create new translate with this lang
                          else{   
                              $new_translate_ba = new PartnerTranslations();
                              $new_translate_ba->partner_id=$ba->id;
                              $new_translate_ba->locale =$lang->code;
                              $new_translate_ba->title = $title;
                              $new_translate_ba->save();
                              }
                         }


          }//end for
          }//end for
       session()->flash('success','Traduction partners successful');
         return view('admin.Traduction.translate.partners', compact('partners','languages'));
  
    }











/*Galerie*/

    public function Galerie()
    {
          $galeries = Galerie::latest()->get();
          $languages = Language::latest()->get();

    return view('admin.Traduction.translate.galeries', compact('galeries','languages'));
  
    }

    public function StoreGalerie(Request $request)
    {
          $galeries = Galerie::latest()->get();
          $languages = Language::latest()->get();
          
          foreach ($galeries as $key => $ga) {
          foreach ($languages as $key => $lang) {
                     
                     //les champe de galeries translater
                    $titre = $request['titre'.$ga->id.''.$lang->code];
                    $description = $request['description'.$ga->id.''.$lang->code];    
          //dd($titre);
              if ($titre!=null) {
                     //test si deja galeries transalte with this lang

                      $old_transalte=GaleriesTranslations::where('galerie_id',$ga->id)->where('locale',$lang->code)->get();
                        //si deja existe translate donc il faut update 
                         if(count($old_transalte)){

                              $old_translate_ga=GaleriesTranslations::find($old_transalte[0]->id);
                              $old_translate_ga->titre = $titre;
                              $old_translate_ga->description = $description;
                              $old_translate_ga->save();
                             } 
                             //si non il faut create new translate with this lang
                          else{   
                              $new_translate_ga = new GaleriesTranslations();
                              $new_translate_ga->galerie_id=$ga->id;
                              $new_translate_ga->locale =$lang->code;
                              $new_translate_ga->titre = $titre;
                              $new_translate_ga->description = $description;
                              $new_translate_ga->save();
                              }
                         }


          }//end for
          }//end for
       session()->flash('success','Traduction galeries successful');
         return view('admin.Traduction.translate.galeries', compact('galeries','languages'));
  
    }


/*video*/

    public function Video()
    {
          $videos = Video::latest()->get();
          $languages = Language::latest()->get();

    return view('admin.Traduction.translate.videos', compact('videos','languages'));
  
    }

    public function StoreVideo(Request $request)
    {
          $videos = Video::latest()->get();
          $languages = Language::latest()->get();
          
          foreach ($videos as $key => $ga) {
          foreach ($languages as $key => $lang) {
                     
                     //les champe de videos translater
                    $title = $request['title'.$ga->id.''.$lang->code];
                    $description = $request['description'.$ga->id.''.$lang->code];    
          //dd($title);
              if ($title!=null) {
                     //test si deja videos transalte with this lang

                      $old_transalte=VideoTranslations::where('video_id',$ga->id)->where('locale',$lang->code)->get();
                        //si deja existe translate donc il faut update 
                         if(count($old_transalte)){

                              $old_translate_ga=VideoTranslations::find($old_transalte[0]->id);
                              $old_translate_ga->title = $title;
                              $old_translate_ga->description = $description;
                              $old_translate_ga->save();
                             } 
                             //si non il faut create new translate with this lang
                          else{   
                              $new_translate_ga = new VideoTranslations();
                              $new_translate_ga->video_id=$ga->id;
                              $new_translate_ga->locale =$lang->code;
                              $new_translate_ga->title = $title;
                              $new_translate_ga->description = $description;
                              $new_translate_ga->save();
                              }
                         }


          }//end for
          }//end for
       session()->flash('success','Traduction Videos successful');
         return view('admin.Traduction.translate.videos', compact('videos','languages'));
  
    }













            /*---------------------Blog-------------------------------*/


    public function CategoriePost()
    {
          $categorieposts = CategoriePost::latest()->get();
          $languages = Language::latest()->get();

    return view('admin.Traduction.translate.categorieposts', compact('categorieposts','languages'));
  
    }

    public function StoreCategoriePost(Request $request)
    {
          $categorieposts = CategoriePost::latest()->get();
          $languages = Language::latest()->get();
          
          foreach ($categorieposts as $key => $ca) {
          foreach ($languages as $key => $lang) {
                     
                     //les champe de categorieposts translater
                    $name = $request['name'.$ca->id.''.$lang->code];
          //dd($name);
              if ($name!=null) {
                     //test si deja categorieposts transalte with this lang

                      $old_transalte=CategoriePostTranslations::where('categorie_post_id',$ca->id)->where('locale',$lang->code)->get();
                        //si deja existe translate donc il faut update 
                         if(count($old_transalte)){

                              $old_translate_ca=CategoriePostTranslations::find($old_transalte[0]->id);
                              $old_translate_ca->name = $name;
                              $old_translate_ca->save();
                             } 
                             //si non il faut create new translate with this lang
                          else{   
                              $new_translate_ca = new CategoriePostTranslations();
                              $new_translate_ca->categorie_post_id=$ca->id;
                              $new_translate_ca->locale =$lang->code;
                              $new_translate_ca->name = $name;
                              $new_translate_ca->save();
                              }
                         }


          }//end for
          }//end for
       session()->flash('success','Traduction categorie posts successful');
         return view('admin.Traduction.translate.categorieposts', compact('categorieposts','languages'));
  
    }





    public function Tag()
    {
          $tags = Tag::latest()->get();
          $languages = Language::latest()->get();

    return view('admin.Traduction.translate.tags', compact('tags','languages'));
  
    }

    public function StoreTag(Request $request)
    {
          $tags = Tag::latest()->get();
          $languages = Language::latest()->get();
          
          foreach ($tags as $key => $tag) {
          foreach ($languages as $key => $lang) {
                     
                     //les champe de tags translater
                    $name = $request['name'.$tag->id.''.$lang->code];
          //dd($name);
              if ($name!=null) {
                     //test si deja tags transalte with this lang

                      $old_transalte=TagTranslations::where('tag_id',$tag->id)->where('locale',$lang->code)->get();
                        //si deja existe translate donc il faut update 
                         if(count($old_transalte)){

                              $old_translate_ca=TagTranslations::find($old_transalte[0]->id);
                              $old_translate_ca->name = $name;
                              $old_translate_ca->save();
                             } 
                             //si non il faut create new translate with this lang
                          else{   
                              $new_translate_ca = new TagTranslations();
                              $new_translate_ca->tag_id=$tag->id;
                              $new_translate_ca->locale =$lang->code;
                              $new_translate_ca->name = $name;
                              $new_translate_ca->save();
                              }
                         }


          }//end for
          }//end for
       session()->flash('success','Traduction tags successful');
         return view('admin.Traduction.translate.tags', compact('tags','languages'));
  
    }

            /*post*/

    public function Post()
    {
          $posts = Post::latest()->get();
          $languages = Language::latest()->get();

    return view('admin.Traduction.translate.posts', compact('posts','languages'));
  
    }

    public function StorePost(Request $request)
    {
          $posts = Post::latest()->get();
          $languages = Language::latest()->get();
          
          foreach ($posts as $key => $post) {
          foreach ($languages as $key => $lang) {
                     
                     //les champe de posts translater
                    $title = $request['title'.$post->id.''.$lang->code];
                    $description = $request['description'.$post->id.''.$lang->code];    
          //dd($title);
              if ($title!=null) {
                     //test si deja posts transalte with this lang

                      $old_transalte=PostTranslations::where('post_id',$post->id)->where('locale',$lang->code)->get();
                        //si deja existe translate donc il faut update 
                         if(count($old_transalte)){

                              $old_translate_ga=PostTranslations::find($old_transalte[0]->id);
                              $old_translate_ga->title = $title;
                              $old_translate_ga->description = $description;
                              $old_translate_ga->save();
                             } 
                             //si non il faut create new translate with this lang
                          else{   
                              $new_translate_ga = new PostTranslations();
                              $new_translate_ga->post_id=$post->id;
                              $new_translate_ga->locale =$lang->code;
                              $new_translate_ga->title = $title;
                              $new_translate_ga->description = $description;
                              $new_translate_ga->save();
                              }
                         }


          }//end for
          }//end for
       session()->flash('success','Traduction posts successful');
         return view('admin.Traduction.translate.posts', compact('posts','languages'));
  
    }

/*-------------------------------*/



}
