<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Partner;
use Toastr;
use Carbon\Carbon;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\Facades\Image;
use Illuminate\Validation\Rule;
use Illuminate\Support\Str;

class PartnerController extends Controller
{
    
     public function index()
    {   
        
        $partners = Partner::latest()->get();

        return view('admin.partners.index', compact('partners'));
    }

   


    public function create()
    {
    return view('admin.partners.create');
    }

    

    public function store(Request $request)
    {
          //validation
       $this->validate($request,[
            'title'=>'required|max:191|unique:partners',
            'image'=> 'image|mimes:jpeg,jpg,png',
             ]);
        
         $image = $request->file('image');
         $slug  = Str::slug($request->title);
         $imagename ="";
        //upload image
        if(isset($image)){
            $currentDate = Carbon::now()->toDateString();
            $imagename = $slug.'-'.$currentDate.'-'.uniqid().'.'.$image->getClientOriginalExtension();

            if(!Storage::disk('public')->exists('partners')){
                Storage::disk('public')->makeDirectory('partners'); }
            
             $PImage = Image::make($image->getRealPath());
             $PImage->stream();
            Storage::disk('public')->put('partners/'.$imagename, $PImage);
                                           }
         else{ $imagename="default.png"; }                                  

         //new partner
        $partner              = new Partner();
        $partner->title       = $request->title;
        $partner->image       = $imagename;
        $partner->save();
        
        Toastr::success('message', 'Partner created successfully.');
        return redirect()->route('admin.partners.index');
    }
   

  

    public function edit($id)
    {
       $partner=Partner::findOrFail($id);

       return view('admin.partners.edit', compact('partner'));
    }



    public function update(Request $request, $id)
    {

                  //validation
       $this->validate($request,[
            'title'=>['required','max:191',Rule::unique("partners")->ignore($id)],
            'image'=> 'image|mimes:jpeg,jpg,png',
             ]);

         //new partner
        $partner= Partner::findOrFail($id);
       //upload new  images
       $image= $request->file('image');
       //upload image
        if(isset($image)){

            $currentDate = Carbon::now()->toDateString();
            $imageName= $currentDate.'-'.uniqid().'.'.$image->getClientOriginalExtension();
            
            //cree new folder si not existe
            if(!Storage::disk('public')->exists('partners')){
                Storage::disk('public')->makeDirectory('partners');}
            // delete old image
            if(Storage::disk('public')->exists('partners/'.$partner->image)){
                Storage::disk('public')->delete('partners/'.$partner->image);}

            $partnerImage = Image::make($image->getRealPath());
            $partnerImage->stream();
            Storage::disk('local')->put('public/partners/'.$imageName, $partnerImage);
            
            $partner->image = $imageName;
        } 


       
        
        $partner->title = $request->title;
        $partner->save();
        
        Toastr::success('message', 'Partner Updated successfully.');
        return redirect()->route('admin.partners.index');
    }


    public function destroy(Request $re,$id)
    {
        $partner=Partner::findOrFail($id);
        
        if (Storage::disk('public')->exists('partners/' . $partner->image)) {
                    Storage::disk('public')->delete('partners/' . $partner->image);
                }

        $partner->delete();
        Toastr::success('message', 'Partner Deleted successfully.');
        return redirect()->route('admin.partners.index');
    }

}
