<?php

namespace App\Http\Controllers\Admin\Blog;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\Facades\Image;
use Illuminate\Validation\Rule;
use Carbon\Carbon;
use Toastr;
use App\CategoriePost;
use Session;
use DB;

class CategoryController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth:admin');
    }




    public function index()
    {
        $categories = CategoriePost::latest()->get();
        return view('admin.blog.categories.index', compact('categories'));
    }

   
    public function create()
    {
        return view('admin.blog.categories.create');
    }



    public function store(Request $request)
    {

        $this->validate($request,[
            'name' => 'required|unique:categorie_posts',
            'image' => 'required|mimes:jpeg,png,jpg'
        ]);

        // get form image
        $image = $request->file('image');
        $slug  = Str::slug($request->name);

        if(isset($image)){
          // make unique  name for image

            $currentDate  = Carbon::now()->toDateString();
            $imagename = $slug.'-'.$currentDate.'-'.uniqid().'.'.$image->getClientOriginalExtension();

            if(!Storage::disk('public')->exists('categoriePost')){

                Storage::disk('public')->makeDirectory('categoriePost');
            }
 
            $category = Image::make($image->getRealPath());
            $category->stream();
            Storage::disk('public')->put('categoriePost/'.$imagename, $category);

            if(!Storage::disk('public')->exists('categoriePost/slider')){

                Storage::disk('public')->makeDirectory('categoriePost/slider');
            }

            // resizeimage Slider 
            $slider = Image::make($image->getRealPath())->resize(500,333);
            $slider->stream();
            Storage::disk('public')->put('categoriePost/slider/'.$imagename, $slider);

        } else {
            $imagename = "default.png";
        }


        $CategoriePost= new CategoriePost();
        $CategoriePost->name=$request->name;
        $CategoriePost->slug=Str::slug($request->name);
        $CategoriePost->image=$imagename;
        $CategoriePost->save();
        
        
        Toastr::success('message', 'CategoriePost created successfully.'); 
        return redirect('/admin/categoriePost');
    }





    public function edit($id)
    {
        $category = CategoriePost::find($id);
        return view('admin.blog.categories.edit', compact('category'));

    }





    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => ['required',Rule::unique("categorie_posts")->ignore($id)],
            'image' => 'mimes:jpeg,png,jpg'
        ]);

        // get form image
        $image = $request->file('image');
        $slug  = Str::slug($request->name);

        $category = CategoriePost::find($id);
        

        if(isset($image)){
          // make unique  name for image

            $currentDate  = Carbon::now()->toDateString();
            $imagename = $slug.'-'.$currentDate.'-'.uniqid().'.'.$image->getClientOriginalExtension();

            if(!Storage::disk('public')->exists('categoriePost')){

                Storage::disk('public')->makeDirectory('categoriePost');
            }

            // delete old image
            if(Storage::disk('public')->exists('categoriePost/'.$category->image)){
                Storage::disk('public')->delete('categoriePost/'.$category->image);
            }

            // resizeimage
            $categoryname = Image::make($image->getRealPath());
            $categoryname->stream();
            Storage::disk('public')->put('categoriePost/'.$imagename, $categoryname);


            if(!Storage::disk('public')->exists('categoriePost/slider')){

                Storage::disk('public')->makeDirectory('categoriePost/slider');
            }
            // delete old image
            if(Storage::disk('public')->exists('categoriePost/slider/'.$category->image)){
                Storage::disk('public')->delete('categoriePost/slider/'.$category->image);
            }

            // resizeimage Slider
            $slider = Image::make($image->getRealPath())->resize(500,333);
            $slider->stream();
            Storage::disk('public')->put('categoriePost/slider/'.$imagename, $slider);
    
        } else {
            $imagename =$category->image;
        }


        
        $category->name=$request->name;
        $category->slug=Str::slug($request->name);
        $category->image=$imagename;
        $category->save();
        
        
        Toastr::success('message', 'CategoriePost Updated successfully.'); 
        return redirect('/admin/categoriePost');
    }







    public function destroy($id)
    {
        $category = CategoriePost::find($id);
        if(Storage::disk('public')->exists('categoriePost/'.$category->image)){
            Storage::disk('public')->delete('categoriePost/'.$category->image);
        }

        if(Storage::disk('public')->exists('categoriePost/slider/'.$category->image)){
            Storage::disk('public')->delete('categoriePost/slider/'.$category->image);
        }

        $category->delete();

        Toastr::success('message', 'CategoriePost Deleted successfully.'); 
        return redirect('/admin/categoriePost');
    }
}
