<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\Facades\Image;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Input;
use Carbon\Carbon;
use App\Attrib;
use App\Product;
use Session;
use DB;
use Validator;
use Toastr;

class AttribController extends Controller
{


    public function show($id)
    {
        $attribs = Attrib::where('product_id',$id)->get();
        $product = Product::findOrFail($id);
               
        return view('admin.products.attrib.index', compact('attribs','product'));
    }



    public function store(Request $request)
    {

        $this->validate($request, [
            // 'images'            => 'required',
        ]);


        $images = $request->file('images');
        $imageNames = "";
        
        //upload images
        if (isset($images)) {

            //cree folder attribs
            if (!Storage::disk('public')->exists('attribs')) {
                Storage::disk('public')->makeDirectory('attribs');
            }
            //save this images in folder attribs     
            foreach ($images as $image) {

                $currentDate = Carbon::now()->toDateString();
                $imageName = $currentDate . '-' . uniqid() . '.' . $image->getClientOriginalExtension();


                  $img = Image::make($image->getRealPath())->resize(800,700);
                 $img->stream('png',100);
                Storage::disk('local')->put('public/attribs/' . $imageName, $img);

                $imageNames .= $imageName . '|';
            }
        } else {
            $imageNames = "default.png";
        }


        $attrib = new Attrib();

        $attrib->product_id = $request->product_id;
        $attrib->title = $request->title;
        $attrib->images = $imageNames;
        $attrib->description = $request->description;
        $attrib->save();

        Toastr::success('message', 'attrib created successfully.'); 
        return redirect()->route('admin.attrib.show',$request->product_id);
    }











    public function edit($id){
        $attrib = Attrib::findOrFail($id);
            return view('admin.products.attrib.edit', compact('attrib')); }
    



    public function update(Request $request, $id)
    {

       $attrib = Attrib::findOrFail($id);

        $images = $request->file('images');
    //upload gallery images
        $imageNames=""; 
        if(isset($images)){
      //cree folder attribs
      if (!Storage::disk('public')->exists('attribs')) {
        Storage::disk('public')->makeDirectory('attribs');}
      //save this images in folder attribs   
        for ($i=0; $i <count($images) ; $i++) {

        $currentDate = Carbon::now()->toDateString();
        $imgName = $currentDate . '-' . uniqid() . '.' . $images[$i]->getClientOriginalExtension();

         $imgs = Image::make($images[$i]->getRealPath());
         $imgs->stream();

        Storage::disk('local')->put('public/attribs/' . $imgName, $imgs);
   
         $imageNames.= $imgName . '|';
           }}
     
 
        $attrib->title = $request->title;
        $attrib->images.= $imageNames;
        $attrib->description = $request->description;
        $attrib->save();

        Toastr::success('message', 'Attribut updated successfully.'); 
        return redirect()->route('admin.attrib.show',$attrib->product_id);

    }





    

    public function deletePhoto(Request $request){
        
        $gallerie = Attrib::whereId($request->id_g)->firstOrFail();
        $images = explode('|', $gallerie->images);
        $new_imageNames = "";
        //delete image property
        for ($i = 0; $i <count($images)-1; $i++) {
            if ($images[$i] == $request->image) {

                if (Storage::disk('public')->exists('attribs/' .$images[$i])) {
                    Storage::disk('public')->delete('attribs/' .$images[$i]);
                }
            } else {
                $new_imageNames .= $images[$i] . '|';
            }
        }
        $gallerie->images = $new_imageNames;
        $gallerie->save();

        if($request->ajax()){ return response()->json(['msg' =>true]);
        }}








    public function destroy($id)
    {
        $attrib = Attrib::findOrFail($id);
        $images = explode('|', $attrib->images);

        //delete images
        for ($i = 0; $i < count($images) - 1; $i++) {

            if (Storage::disk('public')->exists('attribs/' . $images[$i])) {
                Storage::disk('public')->delete('attribs/' . $images[$i]);
            }}

          // DB::table('attribs_translations')->where('attrib_id',$id)->delete();
         
          $attrib->delete();

        Toastr::success('message', 'Attribut deleted successfully.'); 
        return redirect()->route('admin.attrib.show',$attrib->product_id);
    }






}
