<?php

    Route::get('/clear-cache', function() {
        Artisan::call('cache:clear');
        Artisan::call('config:clear');
        Artisan::call('config:cache');
        Artisan::call('view:clear');
        return "Cache is cleared";
    });
    Route::get('/storage-link', function() {
        Artisan::call('storage:link');
        return "Storage is Linked";
    });
  //multi langages
Route::get('/locale/{lang}','HomeController@lange'); 
/////////////////////////////////////////////////////////////////////////////////////////////////////

Auth::routes(['register' => false]);
Auth::routes([
    'register' => false, // Registration Routes...
    'reset' => false, // Password Reset Routes...
    'verify' => false, // Email Verification Routes...
  ]);


  Route::get('send-mail', function () {
   
    $details = [
        'title' => 'Mail from ItSolutionStuff.com',
        'body' => 'This is for testing email using smtp'
    ];
   
    \Mail::to('hello@uxuitrends.com')->send(new \App\Mail\ContactMail($details));
   
    dd("Email is Sent.");
});





Route::get('/', 'HomeController@index')->name('home');
Route::get("/about-us", function() {
    return View("frontend.about");
});
Route::post('/about-us', 'HomeController@messageAbout')->name('about.message');

Route::get("/logistics", function() {
    return View("frontend.logistics");
});
Route::post('/logistics', 'HomeController@messageLog')->name('log.message');


Route::get('/galeries','Front\GalerieController@index')->name('galeries');
Route::get('/galeries/{gal_id}/{slug}','Front\GalerieController@show')->name('ShowGal');




Route::get("/products",'Front\ProductController@index')->name('productsIndex');
Route::get("/products/single/{product_id}/{slug}",'Front\ProductController@single')->name('singleProduct');

Route::get("/galleries", function(){return View("frontend.galleries.index");});
Route::get("/galleries/single", function(){return View("frontend.galleries.single");});

Route::get("/videos", function(){return View("frontend.videos");});

Route::get('/blog','Front\BlogController@blog')->name('blog');
Route::get('/cateory/blog/{categorie_id}/{slug}','Front\BlogController@categorieBlog')->name('CategorieBlog');
Route::get('/Tag/blog/{tag_id}/{slug}','Front\BlogController@tagBlog')->name('TagBlog');
Route::get('/search/blog','Front\BlogController@searchBlog')->name('searchBlog');
Route::get('/blog/{blog_id}/{slug}','Front\BlogController@showBlog')->name('showBlog');
Route::get('/blog/NextPost/{blog_id}/{slug}', 'Front\BlogController@NextPost')->name('NextPost');
Route::get('/blog/PrevPost/{blog_id}/{slug}', 'Front\BlogController@PrevPost')->name('PrevPost');

Route::get("/contact-us", function(){return View("frontend.contact");});
Route::post('/contact-us', 'HomeController@messageContact')->name('contact.message');


















/////////////////////////////////////////////////////////////////////////////////////////////////////
//auth admin
//les Routes de L'authentification Admin
Route::group(['prefix'=>'admin','namespace'=>'Auth','as'=>'admin.'],function(){
    Route::get('/login','adminController@showLoginForm')->name('login');
    Route::post('/login','adminController@login')->name('login');
    Route::post('/logout','adminController@logout')->name('logout'); 
});


//admin
Route::group(['prefix'=>'admin','namespace'=>'Admin','middleware'=>['auth:admin','admin'],'as'=>'admin.'], function(){ 
       Route::get('/','DashboardController@index');
       Route::get('dashboard','DashboardController@index')->name('dashboard');
       Route::get('chartmonth', 'DashboardController@chartmonth')->name('chartmonth');

     

       Route::resource('/product','ProductController');
       Route::get('product/enable/{id}','ProductController@enable');
       Route::resource('/attrib','AttribController')->except(['index','create']); 
       Route::POST('attrib/deletePhotoAttrib','AttribController@deletePhoto')->name('deletePhotoAttrib');
       

       
       Route::resource('/video','VideoController');
       Route::resource('/setting','DashboardController');

       Route::resource('banner','BannerController');
       Route::get('banner/enable/{id}','BannerController@enable'); 
       Route::resource('partners','PartnerController');

       //POSTs
       Route::resource('tag','Blog\TagController');
       Route::resource('categoriePost','Blog\CategoryController');
       Route::resource('post','Blog\PostController');
       Route::get('pending/post', 'Blog\PostController@pending')->name('post.pending');
       Route::get('/post/{id}/approve', 'Blog\PostController@approval')->name('post.approve');
       Route::get('post/enable/{id}','Blog\PostController@enable'); 

      //galleries
      Route::resource('galerie','WebSetting\GalerieController');
      Route::POST('galerie/deletePhoto','WebSetting\GalerieController@deletePhoto')->name('deletePhotoGalerie');
      Route::get('galerie/enable/{id}','WebSetting\GalerieController@enable');  

      //comptes admins et agents
      Route::resource('comptes','AdminController');
      Route::get('compte/enable/{id}','AdminController@enable');  
      Route::get('profile','AdminController@profile')->name('profile');
      Route::post('profile','AdminController@profileUpdate')->name('profile.update');   
      Route::post('changepassword','AdminController@changePasswordUpdate')->name('changepassword.update');
 

       /*---------settings----------*/
       Route::get('settings', 'DashboardController@settings')->name('settings');
       Route::post('settings', 'DashboardController@settingStore')->name('settings.store');
       /*--------message-----------*/
       Route::get('message','DashboardController@message')->name('message');
       Route::get('message/read/{id}','DashboardController@messageRead')->name('message.read');
       Route::get('message/replay/{id}','DashboardController@messageReplay')->name('message.replay');
       Route::post('message/replay','DashboardController@messageSend')->name('message.send');
       Route::post('message/readunread','DashboardController@messageReadUnread')->name('message.readunread');
       Route::delete('message/delete/{id}','DashboardController@messageDelete')->name('messages.destroy');
       Route::post('message/mail', 'DashboardController@contactMail')->name('message.mail');
 

/*============================Translate===========================================*/
  
    Route::get('/translate/Product','TranslateController@Product')->name('translate.Product');
    Route::post('/translate/Product','TranslateController@StoreProduct')->name('translate.Product');
    /*Geosites*/
    Route::get('/translate/Attrib/{product_id}','TranslateController@Attrib')->name('translate.Attrib');
    Route::post('/translate/Attrib/{product_id}','TranslateController@StoreAttrib')->name('translate.Attrib');
    
    Route::get('/translate/Banner','TranslateController@Banner')->name('translate.Banner');
    Route::post('/translate/Banner','TranslateController@StoreBanner')->name('translate.Banner');
     //Translate Web Setting
    Route::get('/translate/Partner','TranslateController@Partner')->name('translate.Partner');
    Route::post('/translate/Partner','TranslateController@StorePartner')->name('translate.Partner');
     //Translate Galleries
    Route::get('/translate/Galerie','TranslateController@Galerie')->name('translate.Galerie');
    Route::post('/translate/Galerie','TranslateController@StoreGalerie')->name('translate.Galerie');
         /*Video*/
    Route::get('/translate/Video','TranslateController@Video')->name('translate.Video');
    Route::post('/translate/Video','TranslateController@StoreVideo')->name('translate.Video');
   
     //Translate Blog
    Route::get('/translate/CategoriePost','TranslateController@CategoriePost')->name('translate.CategoriePost');
    Route::post('/translate/CategoriePost','TranslateController@StoreCategoriePost')->name('translate.CategoriePost');
    Route::get('/translate/Tag','TranslateController@Tag')->name('translate.Tag');
    Route::post('/translate/Tag','TranslateController@StoreTag')->name('translate.Tag');
    Route::get('/translate/Post','TranslateController@Post')->name('translate.Post');
    Route::post('/translate/Post','TranslateController@StorePost')->name('translate.Post');


   });



