@extends('frontend.layouts.app')

@section('title', 'Présentation')

@section('content')


<section class="breadcrumb-area" style="background-image: 
linear-gradient(to right bottom, rgba(113, 5, 36, 0.87), rgba(28, 114, 81, 0.78)), url({{asset('frontend/images/breadcrumb/cover02.jpg')}});">  <div class="container">
      <div class="row">
          <div class="col-xl-12">
              <div class="inner-content clearfix">
                  <div class="title">
                     <h1>LA CHARTE DU GÉOPARC
                    </h1>
                  </div>
                  <div class="breadcrumb-menu">
                      <ul class="clearfix">
                          <li><a href="index-2.html">Accueil</a></li>
                          <li class="active">LA CHARTE DU GÉOPARC
                          </li>
                      </ul>    
                  </div>
              </div>
          </div>
      </div>
  </div>
</section>







<section class="about-style01-area">
  <div class="container">
      <div class="row align-items-center justify-content-center">
 
          <div class="col-xl-10 col-lg-12">
              <div class="about-style1-content">
                
                  
                  <div class="inner-content">
                      
                      <div class="text">
                        La Charte Geoparc UNESCO du M’Goun est un engagement entre les établissements d’hébergements et de restauration touristique classés candidats au label et le Geoparc UNESCO du M’Goun. Cet engagement définit le cadre général applicable aux candidats et aux lauréats. Cet engagement a pour finalité de développer des comportements Eco citoyens en incluant l’éducation à l’environnement et au développement durable dans la gestion quotidienne de leurs activités. 
                      </div>
                    
                  </div>    
              </div>   
          </div>
          
      </div> 
  </div>    
</section>





<section class="about-style01-area" style=" background: url({{asset('frontend/images/pattern/pattern-bg1.png')}}) #fbfffe;
background-repeat: repeat;">
  <div class="container">
      <div class="row align-items-center justify-content-center">
        <div class="col-xl-6 col-lg-12 text-center">
            <div class="about-style1-content section-header">
              <div class="section-title-border">
                {{-- <span>LES UNITÉS </span> --}}
                <h1>LES UNITÉS ADHÉRENTES</h1>
              </div>
                
            </div>   
        </div>
      </div> 
      @foreach($chartes as $charte)

        <div class="row align-items-center p-top-40 ">
            <div class="col-xl-6 col-lg-12">
                <div class="about-style1-content section-header">
                  <div class="section-title-border">
                    <h1>{{getTranslationCharte($charte->id)['title']}}</h1>
                  </div>
                    
                    <div class="inner-content">
                      <div>
                        @if($charte->location)
                          <div class="itemIcon">
                            <div class="ss-icon">
                              <span class="flaticon-maps-and-flags fe-icon"></span>
                            </div>
                            <div class="title">
                                <h6>{{$charte->location}}</h6>
                            </div>
                          </div>
                        @else
                        <span></span>
                        @endif
                        @if($charte->phone)
                          <div class="itemIcon">
                            <div class="ss-icon">
                              <span class="flaticon-call fe-icon"></span>
                            </div>
                            <div class="title">
                                <h6>{{$charte->phone}}</h6>
                            </div>
                          </div>
                          @else
                          <span></span>
                          @endif
                          @if($charte->email)
                          <div class="itemIcon">
                            <div class="ss-icon">
                              <span class="flaticon-envelope fe-icon"></span>
                            </div>
                            <div class="title">
                                <h6><a href="tel:16234569400">{{$charte->email}}</a></h6>
                            </div>
                          </div>
                          @else
                          <span></span>
                          @endif
                          @if($charte->site)
                          <div class="itemIcon">
                            <div class="ss-icon">
                              <span class="flaticon-global fe-icon"></span>
                            </div>
                            <div class="title">
                                <h6><a href="tel:16234569400">{{$charte->site}}</a></h6>
                            </div>
                          </div>
                          @else
                          <span></span>
                          @endif
                      </div>
                      
                    </div>    
                </div>   
            </div>

            <div class="col-xl-6 col-lg-12">
              <div class="about-style1-left-content clearfix">
                <div class="recent-post">
                  <div class="recent-post-carousel owl-carousel owl-theme owl-nav-style-one">
                    <?php   $images=explode('|',$charte->images); ?>
          
                      @for($i=0; $i <@count($images)-1; $i++)
                      <div class="single-recent-post">
                          <div class="img-holder">
                              <img src="{{asset('storage/chartes/'.$images[$i])}}" alt="Awesome Image">
                              <div class="overlay-style-one bg1"></div>
                          </div>
                      </div>
                      @endfor
                    
                  </div> 
                </div>
              </div>     
            </div>
        </div>  
      @endforeach

    
  </div>    
</section>






@endsection

@section('scripts')

@endsection
