@extends('frontend.layouts.app')

@section('title', 'Agenda')

@section('content')


<section class="breadcrumb-area" style="background-image: 
linear-gradient(to right bottom, rgba(113, 5, 36, 0.87), rgba(28, 114, 81, 0.78)), url({{asset('frontend/images/breadcrumb/cover02.jpg')}});">  <div class="container">
      <div class="row">
          <div class="col-xl-12">
              <div class="inner-content clearfix">
                  <div class="title">
                     <h1>AGENDA </h1>
                  </div>
                  <div class="breadcrumb-menu">
                      <ul class="clearfix">
                          <li><a href="index-2.html">Accueil</a></li>
                          <li class="active">AGENDA</li>
                      </ul>    
                  </div>
              </div>
          </div>
      </div>
  </div>
</section>


<section class="events-style3-area pdbottom0">
  <div class="container">
      <div class="row">
          <div class="col-xl-9">
            @foreach($agendas  as $agenda)

              <div class="single-event-box-style3">
                  <div class="row">
                      <div class="col-xl-5">
                          <div class="title-holder">
                              <span>{{$agenda->location}}</span>
                              <h2><a href="{{route('agendasSingle',[$agenda->id,$agenda->slug])}}">{{getTranslationAgenda($agenda->id)['title']}}</a></h2>

                              <p>
                                {{ \Carbon\Carbon::parse($agenda->date_d)->format('M')}}
                                 {{ \Carbon\Carbon::parse($agenda->date_d)->format('d')}}, 
                                 {{ \Carbon\Carbon::parse($agenda->date_d)->format('Y')}} -
                                {{ \Carbon\Carbon::parse($agenda->date_f)->format('M')}} 
                                {{ \Carbon\Carbon::parse($agenda->date_f)->format('d')}}, 
                                {{ \Carbon\Carbon::parse($agenda->date_f)->format('Y')}}</p>
                              {{-- <div class="button">
                                  <a class="btn-two" href="{{route('agendasSingle',[$agenda->id,$agenda->slug])}}">Lire la suite</a>
                              </div> --}}
                          </div> 
                      </div>
                      <div class="col-xl-5">
                          <div class="img-holder">
                              <div class="inner">
                                        @if(Storage::disk('public')->exists('agendas/'.$agenda->img))
                                            <img src="{{asset('storage/agendas/'.$agenda->img)}}" alt="{{getTranslationAgenda($agenda->id)['title']}}">
                                        @endif

                                  <div class="overlay-style-one bg1"></div>
                              </div>
                          </div> 
                      </div>
                      <div class="col-xl-2">
                          <div class="date-holder">
                              <div class="inner">
                                  <h1>{{ \Carbon\Carbon::parse($agenda->date_d)->format('d')}}<span>{{ \Carbon\Carbon::parse($agenda->date_d)->format('M')}}</span></h1>
                                  <h3>{{ \Carbon\Carbon::parse($agenda->date_d)->format('Y')}}</h3>
                              </div>    
                          </div>
                      </div>
                  </div>  
              </div>
              @endforeach

          </div>


          <div class="col-xl-3 col-lg-5 col-md-9 col-sm-12">
            <div class="sidebar-wrapper" style="    background: #fbfbfb;
            padding: 18px;
            border-radius: 10px;">
                <div class="single-sidebar">
                    <div class="title">
                        <h3>Les GeoSites</h3>
                    </div>
                    <ul class="categories clearfix">
   
                 @foreach($geosites as $key => $geosite)
                         <li><a href="{{route('singleProduct',[$geosite->id,$geosite->slug])}}">{{getTranslationProduct($product->id)['title']}}</a></li>
                  @endforeach  

                      </ul>
                </div>
                <div class="single-sidebar">
                    <div class="title">
                        <h3>Recent Events</h3>
                    </div>
                    <div class="recent-post">
                        <div class="recent-post-carousel owl-carousel owl-theme owl-nav-style-one">
                    
                    @foreach($events  as $event)
                            <div class="single-recent-post" style="border:none">
                                <div class="img-holder">

                                        @if(Storage::disk('public')->exists('events/'.$event->img))
                                            <img src="{{asset('storage/events/'.$event->img)}}" alt="{{ getTranslationEvent($event->id)['title'] }}" width="60" class="img-responsive img-rounded">
                                        @elseif(Storage::disk('public')->exists('agendas/'.$event->img))
                                            <img src="{{asset('storage/agendas/'.$event->img)}}" alt="{{ getTranslationEvent($event->id)['title'] }}" width="60" class="img-responsive img-rounded">
                                        @endif

                                    <div class="overlay-style-one bg1"></div>
                                </div>
                                <div class="title-holder text-center">
                                    <p>{{ \Carbon\Carbon::parse($event->date_d)->format('M')}}
                                 {{ \Carbon\Carbon::parse($event->date_d)->format('d')}}, 
                                 {{ \Carbon\Carbon::parse($event->date_d)->format('Y')}}</p>
                                    <h3 style="    font-size: 17px;
                                    line-height: 27px;"><a href="{{route('eventsSingle',[$event->id,$event->slug])}}">
                                    {{ getTranslationEvent($event->id)['title'] }}</a></h3>
                                </div>    
                            </div>
                       @endforeach     
                          
                        </div> 
                    </div>
                </div>
              
            </div>    
        </div>
      </div>
      
  </div>
</section>




@endsection

@section('scripts')

@endsection
