@extends('backend.layouts.app')

@section('title', 'Create Video')

@push('styles')
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-fileinput/4.4.5/css/fileinput.min.css" media="all" rel="stylesheet" type="text/css" />
@endpush


@section('content')


    <div class="block-header">
        <ol class="breadcrumb breadcrumb-col-pink">
                                <li><a href="/admin"><i class="material-icons">home</i> Home</a></li>
                                <li><a href="{{route('admin.video.index')}}"><i class="material-icons">receipt</i> Video </a></li>
                                <li class="active"><i class="material-icons">add</i>Add Video</li>
                            </ol>
    </div>


<form method="POST" action="{{route('admin.video.store')}}" enctype="multipart/form-data"  id="form_validation"  novalidate="novalidate">
    @csrf
    <div class="row clearfix">



        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
            <div class="card">
               <div class="body">                
                    <!--row clearfix -->
                   <div class="row clearfix">
                  <div class="col-sm-6">
                       <div class="form-group form-float">
                        <div class="form-line">
                            <input type="text" name="titre" id="tag_name1" class="form-control" value="{{ old('titre') }}" required="">
                            <label class="form-label"> <strong style="color:black"> Title  </strong> <span style="color:red">*</span> :</label>
                            </div>
                    </div>  
                     </div>


                  <div class="col-sm-6">
                       <div class="form-group form-float">
                        <div class="form-line">
                            <input type="url" name="link" id="tag_name1" class="form-control" value="{{ old('link') }}" required="">
                            <label class="form-label"> <strong style="color:black"> Link Video  </strong> <span style="color:red">*</span> :</label>
                            </div>
                            <p><b>Youtube:</b> https://www.youtube.com/embed/ <span style="color: red">ID VIDEO ICI</span></p>
                            <p><b>Vimeo:</b> https://player.vimeo.com/video/<span style="color: red">ID VIDEO ICI</span></p>
                    </div>  
                     </div>



                 </div>

<!-- ----------------------------------------------------------- -->
<div class="row clearfix">

                  <div class="col-sm-8">
           <label class="col-form-label"> <strong style="color:black"> Image  </strong><span style="color:red">*</span></label>               
                        <div class="form-group form-float">
                            <input type="file" name="image" id="profile-image-input" style="display:none;" required=""  accept="image/*">
                            <button type="button" class="btn bg-white btn-sm waves-effect m-t-15" id="profile-image-btn">
                                <i class="material-icons" style="color:black">image</i>
                                <span style="color:black">UPLOAD IMAGE</span>
                            </button><br><br>
                            <img src="" id="profile-imgsrc" class="img-responsive" style="width:130px;height:130px;display: none;">
                       </div>
                   </div>

                           <div class="col-md-4">
                    <label><strong style="color:black"> Status</strong></label>
                         <div class="form-group">
                       <div class="demo-switch">
                           <div class="switch">
                           <label><input type="checkbox" checked="" id="status" name="status" 
                                      {{old('status') == true ? 'checked' : ''}}  ><span class="lever"></span></label>
                                </div>
                            </div>
                            </div>
                    </div> 

</div>

<!--end row clearfix -->
            <div class="row clearfix">
                <div class="col-md-12">
                     <!-- -------------Description-------- -->                 
                    <div class="form-group">
                        <label for="tinymce">Description </label>
                        <textarea name="description" id="tinymce" >{{old('description')}}</textarea>
                    </div>
                </div>
            </div>





                     <button type="submit" class="btn btn-primary btn-block m-t-15 waves-effect"><i class="material-icons">save </i> Add</button>

                    
                </div><!-- end body -->
            </div><!-- end card -->
        </div>




    </div><!-- end row clearfix -->


</form>




@endsection

@push('scripts')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-fileinput/4.4.5/js/fileinput.min.js"></script>
    <script src="{{asset('backend/plugins/tinymce/tinymce.js')}}"></script>
            <!-- validation -->
      <script src="{{ asset('backend/plugins/jquery-validation/jquery.validate.js')}}"></script>
        <!-- Custom Js -->
       <script src="{{ asset('backend/js/pages/forms/form-validation.js')}}"></script>


      <script>

        $(function () {
            tinymce.init({
                selector: "textarea#tinymce",
                theme: "modern",
                height: 300,
                plugins: [
                    'advlist autolink lists link image charmap print preview hr anchor pagebreak',
                    'searchreplace wordcount visualblocks visualchars code fullscreen',
                    'insertdatetime media nonbreaking save table contextmenu directionality',
                    'emoticons template paste textcolor colorpicker textpattern imagetools'
                ],
                toolbar1: 'insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image',
                toolbar2: 'print preview media | forecolor backcolor emoticons',
                image_advtab: true
            });
            tinymce.suffix = ".min";
            tinyMCE.baseURL = '{{asset('backend/plugins/tinymce')}}';
        });
    </script>



<script>
    $(function(){
        function showImage(fileInput,imgID){
            if (fileInput.files[0]) {
                var reader = new FileReader();
                reader.onload = function(e){
                    $(imgID).attr('src',e.target.result);
                    $(imgID).attr('alt',fileInput.files[0].name);
                }
                reader.readAsDataURL(fileInput.files[0]);
            }
        }
        $('#profile-image-btn').on('click', function(){
            $('#profile-image-input').click();
        });
        $('#profile-image-input').on('change', function(){
            showImage(this, '#profile-imgsrc');
    
    var img = document.getElementById('profile-imgsrc');
    img.style.display = 'block';

        });
    })

    </script>

@endpush

