@extends('backend.layouts.app')

@section('title', 'Create Gallerie')

@push('styles')
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-fileinput/4.4.5/css/fileinput.min.css" media="all" rel="stylesheet" type="text/css" />
@endpush


@section('content')


    <div class="block-header">
        <ol class="breadcrumb breadcrumb-col-pink">
                                <li><a href="/admin"><i class="material-icons">home</i> Home</a></li>
                                <li><a href="{{route('admin.galerie.index')}}"><i class="material-icons">photo_library</i> Gallerie </a></li>
                                <li class="active"><i class="material-icons">add</i>Add Gallerie</li>
                            </ol>
    </div>


<form method="POST" action="{{url('admin/galerie')}}" enctype="multipart/form-data"  id="form_validation"  novalidate="novalidate">
    @csrf
    <div class="row clearfix">



        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
            <div class="card">
               <div class="body">
                    

                      
<!--row clearfix -->
                   <div class="row clearfix">
                  <div class="col-sm-8">
                       <div class="form-group form-float">
                        <div class="form-line">
                            <input type="text" name="titre" id="tag_name1" class="form-control" value="{{ old('titre') }}" required="">
                            <label class="form-label"> <strong style="color:black"> Title  </strong> <span style="color:red">*</span> :</label>
                            </div>
                    </div>  
                     </div>

                           <div class="col-md-4">
                    <label><strong style="color:black"> Status</strong></label>
                         <div class="form-group">
                       <div class="demo-switch">
                           <div class="switch">
                           <label><input type="checkbox" checked="" id="status" name="status" 
                                      {{old('status') == true ? 'checked' : ''}}  ><span class="lever"></span></label>
                                </div>
                            </div>
                            </div>
                    </div> 




                 </div>




                  <!-- row clearfix -->
                 <div class="row clearfix">
                         <div class="col-sm-12">
                            <label class="form-label"> <strong style="color:black"> videos  </strong> :</label>
                       <div class="form-group form-float">
                        <div class="form-line">
                            <input type="text" name="videos" id="tag_name2" class="form-control" value="{{ old('videos') }}">
                          
                            </div>
                            chaque url doit être suivi d'une virgule ( | ).
                    </div>  
                     </div>
      

                         </div>
                     <!--end row clearfix -->

                                      <div class="col-md-12">
                                        <div class="card" id="div_gallery">
                                            <div class="header">
                                                <h2>Galerie images </h2>
                                            </div>
                                            <div class="body">
                                                <input id="input-id" type="file" name="images[]" class="file" data-preview-file-type="text" multiple
                                                accept="image/*">
                                            </div>
                                        </div>
                                    </div>


<!--end row clearfix -->
            <div class="row clearfix">
                <div class="col-md-12">
                     <!-- -------------Description-------- -->                 
                    <div class="form-group">
                        <label for="tinymce">Description </label>
                        <textarea name="description" id="tinymce" >{{old('description')}}</textarea>
                    </div>
                </div>
            </div>





                     <button type="submit" class="btn btn-primary btn-block m-t-15 waves-effect"><i class="material-icons">save </i> Add</button>

                    
                </div><!-- end body -->
            </div><!-- end card -->
        </div>




    </div><!-- end row clearfix -->


</form>




@endsection

@push('scripts')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-fileinput/4.4.5/js/fileinput.min.js"></script>
    <script src="{{asset('backend/plugins/tinymce/tinymce.js')}}"></script>
            <!-- validation -->
      <script src="{{ asset('backend/plugins/jquery-validation/jquery.validate.js')}}"></script>
        <!-- Custom Js -->
       <script src="{{ asset('backend/js/pages/forms/form-validation.js')}}"></script>


      <script>

        $(function () {
            tinymce.init({
                selector: "textarea#tinymce",
                theme: "modern",
                height: 300,
                plugins: [
                    'advlist autolink lists link image charmap print preview hr anchor pagebreak',
                    'searchreplace wordcount visualblocks visualchars code fullscreen',
                    'insertdatetime media nonbreaking save table contextmenu directionality',
                    'emoticons template paste textcolor colorpicker textpattern imagetools'
                ],
                toolbar1: 'insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image',
                toolbar2: 'print preview media | forecolor backcolor emoticons',
                image_advtab: true
            });
            tinymce.suffix = ".min";
            tinyMCE.baseURL = '{{asset('backend/plugins/tinymce')}}';
        });
    </script>


@endpush


