@extends('backend.layouts.app')

@section('title', 'Edit Tags')

@push('styles')

    
@endpush


@section('content')

  <div class="block-header">
        <ol class="breadcrumb breadcrumb-col-pink">
                                <li><a href="/admin"><i class="material-icons">home</i> Home</a></li>
                                <li><a href="{{route('admin.tag.index')}}"><i class="material-icons">label</i> Tags </a></li>
                                <li class="active"><i class="material-icons">edit</i>Edit Tag</li>
                            </ol>
    </div>

    <div class="row clearfix">
        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
            <div class="card">
                <div class="header">
                    <h2>EDIT TAG</h2>
                </div>
                <div class="body">
                    <form action="{{route('admin.tag.update',$tag->id)}}" method="POST" id="form_validation"  novalidate="novalidate">
                        @csrf
                        @method('PUT')

                        <div class="form-group form-float">
                            <div class="form-line">
                                <input type="text" name="name" class="form-control" value="{{$tag->name}}" required="">
                                <label class="form-label">Tag</label>
                            </div>
                        </div>

                      <button type="submit" class="btn btn-primary btn-block m-t-15 waves-effect"><i class="material-icons">edit </i> Modifier</button>

                    </form>
                </div>
            </div>
        </div>
    </div>

@endsection



@push('scripts')
      <!-- validation -->
      <script src="{{ asset('backend/plugins/jquery-validation/jquery.validate.js')}}"></script>
        <!-- Custom Js -->
       <script src="{{ asset('backend/js/pages/forms/form-validation.js')}}"></script>


@endpush
